/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.distributed;

import com.gentics.mesh.cache.CacheRegistry;
import com.gentics.mesh.cache.PermissionCache;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.router.RouterStorage;
import com.gentics.mesh.router.RouterStorageRegistryImpl;
import dagger.Lazy;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.InvalidNameException;

@Singleton
public class DistributedEventManager {
    private static Logger log = LoggerFactory.getLogger(DistributedEventManager.class);
    private final Lazy<Vertx> vertx;
    private final Lazy<Database> db;
    private final RouterStorageRegistryImpl routerStorageRegistry;
    private final Lazy<PermissionCache> permCache;
    private final CacheRegistry cacheRegistry;

    @Inject
    public DistributedEventManager(Lazy<Vertx> vertx, Lazy<Database> db, RouterStorageRegistryImpl routerStorageRegistry, Lazy<PermissionCache> permCache, CacheRegistry cacheRegistry) {
        this.vertx = vertx;
        this.db = db;
        this.routerStorageRegistry = routerStorageRegistry;
        this.permCache = permCache;
        this.cacheRegistry = cacheRegistry;
    }

    public void registerHandlers() {
        EventBus eb = ((Vertx)this.vertx.get()).eventBus();
        eb.consumer(MeshEvent.CLUSTER_NODE_JOINED.address, handler -> {
            log.info((Object)"Received node joined event. Updating content structure information");
            this.handleClusterTopologyUpdate((Message<?>)handler);
        });
        eb.consumer(MeshEvent.CLUSTER_NODE_LEFT.address, handler -> {
            log.info((Object)"Received node left event. Updating content structure information");
            this.handleClusterTopologyUpdate((Message<?>)handler);
        });
        eb.consumer(MeshEvent.CLEAR_PERMISSION_STORE.address, handler -> {
            log.debug((Object)"Received permissionstore clear event");
            ((PermissionCache)this.permCache.get()).clear(false);
        });
        eb.consumer(MeshEvent.CLEAR_CACHES.address, handler -> {
            log.debug((Object)"Received cache clear event");
            this.cacheRegistry.clear();
        });
        eb.consumer(HibProject.TYPE_INFO.getOnCreated().getAddress(), handler -> {
            log.info((Object)"Received project create event");
            this.handleClusterTopologyUpdate((Message<?>)handler);
        });
        eb.consumer(HibProject.TYPE_INFO.getOnUpdated().getAddress(), handler -> {
            log.info((Object)"Received project update event.");
            this.handleClusterTopologyUpdate((Message<?>)handler);
        });
        eb.consumer(MeshEvent.CLUSTER_DATABASE_CHANGE_STATUS.address, handler -> {
            JsonObject info = (JsonObject)handler.body();
            String node = info.getString("node");
            String db = info.getString("database");
            String statusText = info.getString("status");
            boolean online = info.getBoolean("online", Boolean.valueOf(false));
            log.info((Object)("Received status update from node {" + node + ":" + db + "} - " + statusText));
            if (online) {
                this.handleClusterTopologyUpdate((Message<?>)handler);
            }
        });
    }

    private void handleClusterTopologyUpdate(Message<?> handler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Synchronizing the project routers");
        }
        try {
            this.synchronizeProjectRoutes();
        }
        catch (Exception e) {
            log.error((Object)"Error while handling synchronizing projects during topology update event.", (Throwable)e);
            handler.fail(400, "Could not initialize projects.");
        }
        ((PermissionCache)this.permCache.get()).clear();
    }

    private void synchronizeProjectRoutes() throws InvalidNameException {
        Database cdb = (Database)this.db.get();
        cdb.tx(tx -> {
            for (RouterStorage rs : this.routerStorageRegistry.getInstances()) {
                Map registeredProjectRouters = rs.root().apiRouter().projectsRouter().getProjectRouters();
                for (HibProject project : tx.projectDao().findAll()) {
                    if (registeredProjectRouters.containsKey(project.getName())) continue;
                    rs.root().apiRouter().projectsRouter().addProjectRouter(project.getName());
                }
            }
        });
    }
}

