/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.distributed;

import com.gentics.mesh.core.db.cluster.ClusterManager;
import com.gentics.mesh.core.rest.error.Errors;
import com.gentics.mesh.distributed.DistributionUtils;
import com.gentics.mesh.distributed.TopologyChangeReadonlyHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import javax.inject.Inject;

public class TopologyChangeReadonlyHandlerImpl
implements TopologyChangeReadonlyHandler {
    private final ClusterManager clusterManager;

    @Inject
    public TopologyChangeReadonlyHandlerImpl(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void handle(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        String path = request.path();
        HttpMethod method = request.method();
        if (!DistributionUtils.isReadRequest((HttpMethod)method, (String)path) && this.clusterManager != null && this.clusterManager.isClusterTopologyLocked()) {
            rc.fail((Throwable)Errors.error((HttpResponseStatus)HttpResponseStatus.SERVICE_UNAVAILABLE, (String)"error_cluster_topology_readonly", (String[])new String[0]).setLogStackTrace(false));
        } else {
            rc.next();
        }
    }
}

