/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.helper;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;

public class UnexpectedEvent
implements AutoCloseable {
    protected CountDownLatch latch = new CountDownLatch(1);
    protected String address;
    protected int timeoutMs;
    protected MessageConsumer<Object> consumer;

    public UnexpectedEvent(Vertx vertx, String address, int timeoutMs) {
        this.address = address;
        this.timeoutMs = timeoutMs;
        this.consumer = vertx.eventBus().consumer(address);
        this.consumer.handler(msg -> this.latch.countDown());
    }

    @Override
    public void close() {
        try {
            if (this.latch.await(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                Assertions.fail((String)("Event " + this.address + " was handled at least once within timeout"));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.consumer.unregister();
        }
    }
}

