/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.helper;

import io.reactivex.functions.Action;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExpectedEvent
implements AutoCloseable {
    protected CountDownLatch latch = new CountDownLatch(1);
    protected int timeoutMs;
    protected MessageConsumer<Object> consumer;

    public ExpectedEvent(Vertx vertx, String address, Action code, int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.consumer = vertx.eventBus().consumer(address);
        this.consumer.handler(msg -> this.latch.countDown());
        this.consumer.completionHandler(res -> {
            if (res.failed()) {
                throw new RuntimeException("Could not listen to event", res.cause());
            }
            try {
                code.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws TimeoutException {
        try {
            if (!this.latch.await(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timeout while waiting for event");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.consumer.unregister();
        }
    }
}

