/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.verticle.admin;

import com.gentics.mesh.router.EndpointRegistry;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.verticle.admin.AdminGUI2Endpoint;
import com.gentics.mesh.verticle.admin.AdminGUIEndpoint;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.EMPTY, startServer=false)
public class AdminGUIEndpointTest
extends AbstractMeshTest {
    @Before
    public void setupVerticle() throws Exception {
        EndpointRegistry registry = this.mesh().endpointRegistry();
        registry.register(AdminGUIEndpoint.class);
        registry.register(AdminGUI2Endpoint.class);
    }

    @BeforeClass
    public static void cleanupConfig() {
        new File("mesh-ui-config.js").delete();
        new File("mesh-ui-config.js").delete();
    }

    @Test
    public void testAdminConfigRendering() throws InterruptedException, ExecutionException, TimeoutException {
        HttpClient client = this.createHttpClient();
        CompletableFuture future = new CompletableFuture();
        client.request(HttpMethod.GET, "/mesh-ui-v1/mesh-ui-config.js").compose(request -> request.send()).onComplete(rh -> {
            HttpClientResponse response = (HttpClientResponse)rh.result();
            response.bodyHandler(bh -> {
                if (response.statusCode() == 200) {
                    future.complete(bh.toString());
                } else {
                    future.completeExceptionally(new Exception("Status code wrong {" + response.statusCode() + "}"));
                }
            });
        });
        String response = (String)future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("The response string should not contain any html specific characters but it was {" + response + "} "), (response.indexOf("<") != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRedirect() throws InterruptedException, ExecutionException {
        HttpClient client = this.createHttpClient();
        CompletableFuture future = new CompletableFuture();
        client.request(HttpMethod.GET, "/").compose(request -> request.send()).onComplete(rh -> future.complete(((HttpClientResponse)rh.result()).getHeader("Location")));
        Assert.assertEquals((Object)"/mesh-ui/", future.get());
    }
}

