/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.auth;

import com.gentics.mesh.auth.util.KeycloakUtils;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.rest.role.RoleListResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestContext;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;

public abstract class AbstractOAuthTest
extends AbstractMeshTest {
    protected void setAdminToken() {
        this.client().setAPIKey(null);
        this.client().setLogin("joe1", "test123");
        this.client().login().blockingGet();
    }

    protected void setClientTokenFromKeycloak() throws IOException {
        JsonObject authInfo = this.loginKeycloak();
        String token = authInfo.getString("access_token");
        this.client().setAPIKey(token);
    }

    private JsonObject loginKeycloak() throws IOException {
        String secret = "9b65c378-5b4c-4e25-b5a1-a53a381b5fb4";
        int port = MeshTestContext.getKeycloak().getFirstMappedPort();
        return KeycloakUtils.loginKeycloak((String)"http", (String)"localhost", (int)port, (String)"master-test", (String)"mesh", (String)"dummyuser", (String)"finger", (String)secret);
    }

    protected JsonObject get(String path, String token) throws IOException {
        Request request = new Request.Builder().header("Accept", "application/json").header("Authorization", "Bearer " + token).url("http://localhost:" + testContext.getHttpPort() + path).build();
        Response response = this.httpClient().newCall(request).execute();
        return new JsonObject(response.body().string());
    }

    protected String get(String path) throws IOException {
        Request request = new Request.Builder().header("Accept", "application/json").url("http://localhost:" + testContext.getHttpPort() + path).build();
        Response response = this.httpClient().newCall(request).execute();
        System.out.println("Response: " + response.code());
        return response.body().string();
    }

    protected JsonObject loadJson(String path) throws IOException {
        return new JsonObject(IOUtils.toString((URL)this.getClass().getResource(path), (Charset)StandardCharsets.UTF_8));
    }

    protected void assertGroupsOfUser(String userName, String ... expectedGroupNames) {
        UserResponse user = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        List groupNamesOfUser = user.getGroups().stream().map(g -> g.getName()).collect(Collectors.toList());
        Assertions.assertThat(groupNamesOfUser).as("Groups of user {" + userName + "}", new Object[0]).containsExactlyInAnyOrder((Object[])expectedGroupNames);
    }

    protected void assertGroupRoles(String groupName, String ... expectedRoles) {
        String groupUuid = (String)this.tx(tx -> ((HibGroup)tx.groupDao().findByName(groupName)).getUuid());
        RoleListResponse rolesForGroup = (RoleListResponse)ClientHelper.call(() -> this.client().findRolesForGroup(groupUuid, new ParameterProvider[0]));
        List roleNamesOfGroup = rolesForGroup.getData().stream().map(r -> r.getName()).collect(Collectors.toList());
        Assertions.assertThat(roleNamesOfGroup).as("Roles of group {" + groupName + "}", new Object[0]).containsExactlyInAnyOrder((Object[])expectedRoles);
    }
}

