/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.auth;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.auth.AbstractOAuthTest;
import com.gentics.mesh.auth.MapperTestPlugin;
import com.gentics.mesh.auth.util.KeycloakUtils;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.rest.admin.localconfig.LocalConfigModel;
import com.gentics.mesh.core.rest.common.AbstractNameUuidReference;
import com.gentics.mesh.core.rest.group.GroupReference;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.core.rest.user.UserAPITokenResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.plugin.auth.AuthServicePluginUtils;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.test.context.MeshTestContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FailingTests.class})
@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true, useKeycloak=true)
public class OAuth2KeycloakPluginTest
extends AbstractOAuthTest {
    @Before
    public void deployPlugin() throws Exception {
        MapperTestPlugin.reset();
        this.addPublicKey();
        this.deployPlugin(MapperTestPlugin.class, "myMapper");
    }

    private void addPublicKey() throws Exception {
        String realmName = "master-test";
        int port = MeshTestContext.getKeycloak().getFirstMappedPort();
        Set keys = KeycloakUtils.loadJWKs((String)"http", (String)"localhost", (int)port, (String)realmName);
        MapperTestPlugin.publicKeys.addAll(keys);
    }

    @Test
    public void testKeycloakAuth() throws Exception {
        this.setClientTokenFromKeycloak();
        UserResponse me = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((Object)"mapped@email.tld", (Object)me.getEmailAddress());
        Assert.assertEquals((Object)"mappedFirstname", (Object)me.getFirstname());
        Assert.assertEquals((Object)"mappedLastname", (Object)me.getLastname());
        Assert.assertEquals((Object)"dummyuser", (Object)me.getUsername());
        String uuid = me.getUuid();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        UserResponse me2 = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((String)"The uuid should not change. The previously created user should be returned.", (Object)uuid, (Object)me2.getUuid());
        List groupNames = me2.getGroups().stream().map(AbstractNameUuidReference::getName).collect(Collectors.toList());
        Assertions.assertThat(groupNames).as("Groups", new Object[0]).containsOnly((Object[])new String[]{"group1", "group2", "group3"});
        Assert.assertNotNull(this.tx(tx -> (HibGroup)tx.groupDao().findByName("group1")));
        Assert.assertNotNull(this.tx(tx -> (HibGroup)tx.groupDao().findByName("group2")));
        Assert.assertNotNull(this.tx(tx -> (HibRole)tx.roleDao().findByName("role1")));
        Assert.assertNotNull(this.tx(tx -> (HibRole)tx.roleDao().findByName("role2")));
        JsonObject meJson = new JsonObject(this.get("/api/v2/auth/me"));
        Assert.assertEquals((Object)"anonymous", (Object)meJson.getString("username"));
        this.setAdminToken();
        UserAPITokenResponse meshApiToken = (UserAPITokenResponse)ClientHelper.call(() -> this.client().issueAPIToken(me2.getUuid()));
        this.client().logout().blockingGet();
        this.client().setAPIKey(meshApiToken.getToken());
        me = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((Object)"dummyuser", (Object)me.getUsername());
        this.client().setAPIKey("borked");
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
        this.client().setAPIKey(null);
        UserResponse anonymous = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((Object)"anonymous", (Object)anonymous.getUsername());
    }

    @Test
    public void testRejectToken() throws IOException {
        MapperTestPlugin.acceptToken = false;
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED);
    }

    @Test
    public void testRoleFilter() throws Exception {
        MapperTestPlugin.roleFilter = (groupName, roleName) -> {
            System.out.println("Filtering {" + groupName + "} / {" + roleName + "}");
            return groupName.equals("group3") && roleName.equals("role1");
        };
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group1", "group2", "group3");
        this.setAdminToken();
        this.assertGroupRoles("group1", "role3");
        this.assertGroupRoles("group2", "role1");
        this.assertGroupRoles("group3", "role2");
        MapperTestPlugin.roleFilter = null;
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group1", "group2", "group3");
        this.setAdminToken();
        this.assertGroupRoles("group1", "role3");
        this.assertGroupRoles("group2", "role1");
        this.assertGroupRoles("group3", "role1", "role2");
        MapperTestPlugin.roleList.add(new RoleResponse().setName("admin").setGroups(new GroupReference[]{(GroupReference)new GroupReference().setName("group1")}));
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.setAdminToken();
        this.assertGroupRoles("group1", "role3", "admin");
        MapperTestPlugin.reset();
        this.addPublicKey();
        MapperTestPlugin.roleFilter = AuthServicePluginUtils.createRoleFilter(MapperTestPlugin.roleList, MapperTestPlugin.groupList);
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group1", "group2", "group3");
        this.setAdminToken();
        this.assertGroupRoles("group1", "role3");
        this.assertGroupRoles("group2", "role1");
        this.assertGroupRoles("group3", "role1", "role2");
    }

    @Test
    public void testGroupFilter() throws Exception {
        MapperTestPlugin.groupFilter = groupName -> {
            System.out.println("Filtering {" + groupName + "}");
            return groupName.equals("group1");
        };
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group2", "group3");
        MapperTestPlugin.groupFilter = null;
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group1", "group2", "group3");
        MapperTestPlugin.groupList.add(new GroupResponse().setName("admin"));
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group1", "group2", "group3", "admin");
        MapperTestPlugin.reset();
        this.addPublicKey();
        MapperTestPlugin.groupFilter = AuthServicePluginUtils.createGroupFilter(MapperTestPlugin.groupList);
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.assertGroupsOfUser("dummyUser", "group1", "group2", "group3");
    }

    @Test
    public void testDefaultUserMapper() throws IOException {
        MapperTestPlugin.userResult = null;
        this.setClientTokenFromKeycloak();
        UserResponse me = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((Object)"dummy@dummy.dummy", (Object)me.getEmailAddress());
        Assert.assertEquals((Object)"Dummy", (Object)me.getFirstname());
        Assert.assertEquals((Object)"User", (Object)me.getLastname());
        Assert.assertEquals((Object)"dummyuser", (Object)me.getUsername());
    }

    @Test
    public void testAuthWithMultiplePublicKeys() throws IOException {
        JsonObject jwk = this.loadJson("/jwk/dummy-jwk.json");
        MapperTestPlugin.publicKeys.add(jwk);
        MapperTestPlugin.userResult = null;
        this.setClientTokenFromKeycloak();
        UserResponse me = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((Object)"dummy@dummy.dummy", (Object)me.getEmailAddress());
    }

    @Test
    public void testWebroot() throws IOException {
        String parentUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("binary_content");
        nodeCreateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"MyImage"));
        nodeCreateRequest.setParentNodeUuid(parentUuid);
        NodeResponse createdNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode(this.projectName(), nodeCreateRequest, new ParameterProvider[0]));
        this.uploadImage(createdNode, "en", "binary");
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.setAdminToken();
        String role1Uuid = (String)this.tx(tx -> ((HibRole)tx.roleDao().findByName("role1")).getUuid());
        RolePermissionRequest updateRequest = new RolePermissionRequest().setRecursive(Boolean.valueOf(true));
        updateRequest.getPermissions().setRead(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(role1Uuid, "projects/" + this.projectUuid(), updateRequest));
        String groupUuid = (String)this.tx(tx -> ((HibGroup)tx.groupDao().findByName("group1")).getUuid());
        ClientHelper.call(() -> this.client().addRoleToGroup(groupUuid, role1Uuid));
        this.setClientTokenFromKeycloak();
        String nodePath = "/News/2015";
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot(this.projectName(), nodePath, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)nodePath, (Object)response.getNodeResponse().getPath());
        String imagePath = "/News/2015/blume.jpg";
        response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot(this.projectName(), imagePath, new ParameterProvider[0]));
        Assert.assertTrue((boolean)response.isBinary());
    }

    @Test
    public void testReadOnlyMode() throws Exception {
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.setReadOnly(true);
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        this.setClientTokenFromKeycloak();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED, (String)"error_readonly_mode_oauth", (String[])new String[0]);
        this.setReadOnly(false);
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
    }

    private void setReadOnly(boolean readOnly) {
        String key = this.client().getAPIKey();
        this.setAdminToken();
        ClientHelper.call(() -> this.client().updateLocalConfig(new LocalConfigModel().setReadOnly(Boolean.valueOf(readOnly))));
        this.client().setAPIKey(key);
    }
}

