/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cache;

import com.gentics.mesh.cache.ProjectBranchNameCache;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.helper.ExpectedEvent;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class ActionContextBranchCacheTest
extends AbstractMeshTest {
    @Before
    public void setupCache() {
        this.cache().enable();
    }

    private ProjectBranchNameCache cache() {
        return this.mesh().branchCache();
    }

    @Test
    public void testBranchCache() throws TimeoutException {
        if (this.cache().isDisabled()) {
            return;
        }
        String newName = "New Branch Name";
        Assert.assertFalse((String)"Initially the cache should not contain the branch", (boolean)this.hasBranchInCache());
        Assert.assertEquals((long)0L, (long)this.branchCacheSize());
        ClientHelper.call(() -> this.client().findNodes(this.projectName(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
        Assert.assertTrue((String)"The branch should now be cached", (boolean)this.hasBranchInCache());
        Assert.assertEquals((long)1L, (long)this.branchCacheSize());
        BranchUpdateRequest request1 = new BranchUpdateRequest().setName(newName);
        try (ExpectedEvent ee = this.expectEvent(MeshEvent.BRANCH_UPDATED, 10000);){
            ClientHelper.call(() -> this.client().updateBranch(this.projectName(), this.initialBranchUuid(), request1));
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.waitFor(() -> !this.hasBranchInCache(), 10000)).as("Cache has been invalidated within given timeout", new Object[0])).isTrue();
        Assert.assertEquals((long)0L, (long)this.branchCacheSize());
        this.cache().disable();
        ClientHelper.call(() -> this.client().findNodes(this.projectName(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
        Assert.assertFalse((String)"The cache should still not have the entry", (boolean)this.hasBranchInCache());
        Assert.assertEquals((long)0L, (long)this.branchCacheSize());
    }

    private long branchCacheSize() {
        return this.cache().size();
    }

    public boolean hasBranchInCache() {
        return this.cache().get((Object)(this.project().getId() + "-" + this.initialBranchUuid())) != null;
    }
}

