/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cache;

import com.gentics.mesh.cache.EventAwareCache;
import com.gentics.mesh.cache.impl.EventAwareCacheImpl;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.event.EventBusStore;
import com.gentics.mesh.metric.MetricsService;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class EventAwareCacheTest
extends AbstractMeshTest {
    @Test
    public void testCustomHandler() {
        MeshOptions options = this.getTestContext().getOptions();
        options.getMonitoringOptions().setEnabled(false);
        EventBusStore eventBusStore = new EventBusStore();
        eventBusStore.setEventBus(this.vertx().eventBus());
        EventAwareCache USER_STATE_CACHE = new EventAwareCacheImpl.Builder().maxSize(15000L).events(new MeshEvent[]{MeshEvent.USER_UPDATED}).action((event, cache) -> {
            String uuid = ((JsonObject)event.body()).getString("uuid");
            if (uuid != null) {
                cache.invalidate((Object)uuid);
            } else {
                cache.invalidate();
            }
        }).setMetricsService((MetricsService)Mockito.mock(MetricsService.class)).meshOptions(options).name("testcache").eventBusStore(eventBusStore).build();
        String uuid2 = UUIDUtil.randomUUID();
        USER_STATE_CACHE.put((Object)this.userUuid(), (Object)true);
        USER_STATE_CACHE.put((Object)uuid2, (Object)true);
        Assert.assertTrue((String)"The entry was not cached.", (boolean)((Boolean)USER_STATE_CACHE.get((Object)this.userUuid())));
        Assert.assertEquals((String)"There should be two entries in the cache.", (long)2L, (long)USER_STATE_CACHE.size());
        UserUpdateRequest request = new UserUpdateRequest();
        request.setUsername("someothername");
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), request, new ParameterProvider[0]));
        Assert.assertNull((String)"The cache entry should have been invalidated.", (Object)USER_STATE_CACHE.get((Object)this.userUuid()));
        Assert.assertTrue((String)"The other cache entry should be still in the cache.", (boolean)((Boolean)USER_STATE_CACHE.get((Object)uuid2)));
    }
}

