/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cache;

import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibLanguage;
import com.gentics.mesh.core.data.HibNamedElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.error.MeshSchemaException;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.CoreTestUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NameCacheTest
extends AbstractMeshTest {
    public void clearCache() {
        this.adminCall(() -> this.client().clearCache());
    }

    @Test
    public void testCreateProject() {
        this.testCreation("project", (name, tx) -> tx.projectDao().create(name, "localhost", Boolean.valueOf(false), "", this.user(), (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion(), tx.createBatch()), (name, tx) -> (HibProject)tx.projectDao().findByName(name));
    }

    @Test
    public void testCreateRole() {
        this.testCreation("role", (name, tx) -> tx.roleDao().create(name, this.user()), (name, tx) -> (HibRole)tx.roleDao().findByName(name));
    }

    @Test
    public void testCreateBranch() {
        this.testCreation("branch", (name, tx) -> tx.branchDao().create(this.project(), name, this.user(), tx.createBatch()), (name, tx) -> (HibBranch)tx.branchDao().findByName((HibCoreElement)this.project(), name));
    }

    @Test
    public void testCreateTag() {
        this.testCreation("tag", (name, tx) -> tx.tagDao().create(this.tagFamily("colors"), name, this.project(), this.user()), (name, tx) -> (HibTag)tx.tagDao().findByName((HibCoreElement)this.tagFamily("colors"), name));
    }

    @Test
    public void testCreateTagFamily() {
        this.testCreation("tagfamily", (name, tx) -> tx.tagFamilyDao().create(this.project(), name, this.user()), (name, tx) -> (HibTagFamily)tx.tagFamilyDao().findByName((HibCoreElement)this.project(), name));
    }

    @Test
    public void testCreateGroup() {
        this.testCreation("group", (name, tx) -> tx.groupDao().create(name, this.user()), (name, tx) -> (HibGroup)tx.groupDao().findByName(name));
    }

    @Test
    public void testCreateLanguage() {
        this.testCreation("language", (name, tx) -> tx.languageDao().create(name, "lng"), (name, tx) -> (HibLanguage)tx.languageDao().findByName(name));
    }

    @Test
    public void testCreateUser() {
        this.testCreation("user", (name, tx) -> tx.userDao().create(name, this.user()), (name, tx) -> (HibUser)tx.userDao().findByName(name));
    }

    @Test
    public void testCreateSchema() {
        this.testCreation("schema", (name, tx) -> {
            try {
                return tx.schemaDao().create((SchemaVersionModel)new SchemaModelImpl().setName(name), this.user());
            }
            catch (MeshSchemaException e) {
                throw new IllegalStateException(e);
            }
        }, (name, tx) -> (HibSchema)tx.schemaDao().findByName(name));
    }

    @Test
    public void testCreateMicroschema() {
        this.testCreation("microschema", (name, tx) -> tx.microschemaDao().create(new MicroschemaModelImpl().setName(name), this.user(), tx.createBatch()), (name, tx) -> (HibMicroschema)tx.microschemaDao().findByName(name));
    }

    protected <E extends HibNamedElement> void testCreation(String entityName, BiFunction<String, Tx, E> creator, BiFunction<String, Tx, E> lookup) {
        String name = entityName + "_" + Long.toHexString(System.currentTimeMillis());
        this.tx(tx -> {
            HibNamedElement entity = (HibNamedElement)lookup.apply(name, tx);
            Assert.assertNull((Object)entity);
        });
        this.tx(tx -> {
            HibNamedElement entity = (HibNamedElement)creator.apply(name, tx);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)entity.getName(), (Object)name);
        });
        this.tx(tx -> {
            HibNamedElement entity = (HibNamedElement)lookup.apply(name, tx);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)entity.getName(), (Object)name);
        });
    }

    @Test
    public void testProjectCreation() {
        this.testEntityCreation(name -> this.client().createProject(new ProjectCreateRequest().setName(name).setSchemaRef("folder")), name -> this.client().findProjectByName(name, new ParameterProvider[0]), project -> project.getName());
    }

    public <T> void testEntityCreation(Function<String, MeshRequest<T>> creator, Function<String, MeshRequest<T>> lookup, Function<T, String> namer) {
        Object entity;
        String name = "bogus_" + Long.toHexString(System.currentTimeMillis());
        try {
            entity = ClientHelper.call(() -> (MeshRequest)lookup.apply(name));
        }
        catch (Exception e) {
            if (CoreTestUtils.isResponseStatus(e.getCause(), HttpResponseStatus.NOT_FOUND)) {
                entity = null;
            }
            throw e;
        }
        Assert.assertNull((Object)entity);
        entity = ClientHelper.call(() -> (MeshRequest)creator.apply(name));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)namer.apply(entity), (Object)name);
        entity = ClientHelper.call(() -> (MeshRequest)lookup.apply(name));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)namer.apply(entity), (Object)name);
    }
}

