/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cli;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.LanguageAssert;
import com.gentics.mesh.core.data.HibLanguage;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.etc.LanguageEntry;
import com.gentics.mesh.etc.LanguageSet;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=false)
public class BootstrapInitializerTest
extends AbstractMeshTest {
    @Test
    public void testInitLanguages() throws JsonParseException, JsonMappingException, IOException {
        try (Tx tx = this.tx();){
            this.boot().initLanguages();
        }
        String filename = "languages.json";
        InputStream ins = this.getClass().getResourceAsStream("/json/languages.json");
        if (ins == null) {
            throw new NullPointerException("Languages could not be loaded from classpath file {languages.json}");
        }
        LanguageSet languageSet = (LanguageSet)new ObjectMapper().readValue(ins, LanguageSet.class);
        for (Map.Entry entry : languageSet.entrySet()) {
            Tx tx = this.tx();
            try {
                HibLanguage language = tx.languageDao().findByLanguageTag((String)entry.getKey());
                Assert.assertNotNull((Object)language);
                Assert.assertEquals((Object)language.getName(), (Object)((LanguageEntry)entry.getValue()).getName());
                Assert.assertEquals((Object)language.getNativeName(), (Object)((LanguageEntry)entry.getValue()).getNativeName());
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    @Test
    public void testInitCustomLanguages() throws JsonParseException, JsonMappingException, IOException {
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/json/custom-languages.json"), (File)new File("target/custom-languages.json"));
        try (Tx tx = this.tx();){
            this.boot().initLanguages();
            HibLanguage language = tx.languageDao().findByLanguageTag("de");
            ((LanguageAssert)((LanguageAssert)MeshAssertions.assertThat((HibLanguage)language).as("Default language", new Object[0])).isNotNull()).hasTag("de").hasName("German").hasNativeName("Deutsch");
            tx.success();
        }
        MeshOptions configuration = this.options();
        configuration.setLanguagesFilePath("target/custom-languages.json");
        this.boot().initOptionalLanguages(configuration);
        try (Tx tx = this.tx();){
            HibLanguage language = tx.languageDao().findByLanguageTag("sq-KS");
            ((LanguageAssert)((LanguageAssert)MeshAssertions.assertThat((HibLanguage)language).as("Custom language", new Object[0])).isNotNull()).hasTag("sq-KS").hasName("Albanian (Kosovo)").hasNativeName("Shqip (Kosovo)");
            language = tx.languageDao().findByLanguageTag("de");
            ((LanguageAssert)((LanguageAssert)MeshAssertions.assertThat((HibLanguage)language).as("Overwritten default language", new Object[0])).isNotNull()).hasTag("de").hasName("German (modified)").hasNativeName("Deutsch (modifiziert)");
            tx.success();
        }
    }

    @Test
    public void testIndexLookup() {
        try (Tx tx = this.tx();){
            this.boot().initDatabaseTypes();
            this.boot().clearReferences();
            Assert.assertNotNull((Object)this.boot().rootResolver());
        }
    }

    @Test
    public void testIsEmpty() {
        Assert.assertFalse((boolean)this.boot().isEmptyInstallation());
        this.db().clear();
        Assert.assertTrue((boolean)this.boot().isEmptyInstallation());
    }
}

