/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cli;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.dagger.MeshComponent;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.test.MeshOptionsTypeAwareContext;
import org.junit.Assert;
import org.junit.Test;

public abstract class MeshMeshIntegrationTest<T extends MeshOptions>
implements MeshOptionsTypeAwareContext<T> {
    @Test
    public void testMeshMesh() throws Exception {
        MeshOptions optionA = this.getOptions();
        optionA.setNodeName("A");
        optionA.getAuthenticationOptions().setKeystorePassword("ABC");
        optionA.getSearchOptions().setUrl(null);
        optionA.getHttpServerOptions().setPort(8081);
        optionA.getMonitoringOptions().setEnabled(false);
        optionA.getMonitoringOptions().setPort(8082);
        this.setupOptions(optionA);
        Mesh meshA = Mesh.create((MeshOptions)optionA);
        MeshOptions optionB = this.getOptions();
        optionB.setNodeName("B");
        optionB.getAuthenticationOptions().setKeystorePassword("ABC");
        optionB.getSearchOptions().setUrl(null);
        optionB.getHttpServerOptions().setPort(8083);
        optionB.getMonitoringOptions().setEnabled(false);
        optionB.getMonitoringOptions().setPort(8084);
        this.setupOptions(optionB);
        Mesh meshB = Mesh.create((MeshOptions)optionB);
        Assert.assertNotEquals((Object)meshA, (Object)meshB);
        meshA.run(false);
        meshB.run(false);
        System.out.println("Done");
        MeshComponent meshInternalA = (MeshComponent)meshA.internal();
        MeshComponent meshInternalB = (MeshComponent)meshB.internal();
        Assert.assertNotEquals((Object)meshInternalA, (Object)meshInternalB);
        Assert.assertNotEquals((Object)meshInternalA.boot(), (Object)meshInternalB.boot());
        meshInternalA.database().tx(tx -> System.out.println("Admin in A: " + ((HibUser)tx.userDao().findByName("admin")).getUuid()));
        meshInternalB.database().tx(tx -> System.out.println("Admin in B: " + ((HibUser)tx.userDao().findByName("admin")).getUuid()));
        meshA.shutdown();
        meshB.shutdown();
    }

    abstract void setupOptions(T var1);
}

