/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cli;

import com.gentics.mesh.cli.MeshNameProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTimeUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MeshNameProviderTest {
    @Test
    public void testGetRandomName() {
        Assert.assertNotNull((Object)MeshNameProvider.getInstance().getRandomName());
        for (int i = 0; i < 30000; ++i) {
            Assert.assertNotNull((Object)MeshNameProvider.getInstance().getRandomName());
        }
    }

    @Test
    public void testGetName() throws Exception {
        String name = MeshNameProvider.getInstance().getRandomName();
        System.out.println("Got name: {" + name + "}");
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)name));
    }

    @Test
    public void testFirstApril() throws Exception {
        LocalDate inputDate = LocalDate.of(2017, 4, 1);
        MeshNameProvider spy = (MeshNameProvider)Mockito.spy((Object)new MeshNameProvider());
        Mockito.when((Object)spy.getDate()).thenReturn((Object)inputDate);
        String name = spy.getRandomName();
        Assert.assertTrue((String)("We did expect a skynet name but we got none {" + name + "}"), (name.indexOf("Skynet") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonApril() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        Date secondApril = sdf.parse("02-01");
        DateTimeUtils.setCurrentMillisFixed((long)secondApril.getTime());
        String name = MeshNameProvider.getInstance().getRandomName();
        Assert.assertFalse((String)("We did not expect a skynet name but we got one {" + name + "}"), (name.indexOf("Skynet") > 0 ? 1 : 0) != 0);
    }

    @After
    public void cleanUp() {
        DateTimeUtils.setCurrentMillisSystem();
    }
}

