/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.cli;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.dagger.MeshComponent;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.test.MeshOptionsTypeAwareContext;
import java.util.ArrayList;
import org.junit.Test;

public abstract class MultiMeshIntegrationTest<T extends MeshOptions>
implements MeshOptionsTypeAwareContext<T> {
    public static final int INSTANCE_COUNT = 10;

    @Test
    public void testMeshMesh() throws Exception {
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        for (int i = 0; i <= 10; ++i) {
            MeshOptions option = this.getOptions();
            option.setNodeName("M" + i);
            option.getAuthenticationOptions().setKeystorePassword("ABC");
            option.getSearchOptions().setUrl(null);
            option.getHttpServerOptions().setPort(8000 + i);
            option.getMonitoringOptions().setEnabled(false);
            option.getMonitoringOptions().setPort(8500 + i);
            this.setupOptions(option, i);
            Mesh mesh = Mesh.create((MeshOptions)option);
            mesh.run(false);
            System.out.println("Done");
            MeshComponent meshInternal = (MeshComponent)mesh.internal();
            meshInternal.database().tx(tx -> {
                UserDao userDao = tx.userDao();
                System.out.println("Admin: " + ((HibUser)userDao.findByName("admin")).getUuid());
            });
            meshes.add(mesh);
        }
        System.out.println("Press any key to shutdown");
        System.in.read();
        System.out.println("Done.. Shutting them down..");
        for (Mesh mesh : meshes) {
            System.out.println("Shutdown " + mesh.getOptions().getNodeName());
            mesh.shutdown();
        }
    }

    protected abstract void setupOptions(T var1, int var2);
}

