/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.client;

import com.gentics.mesh.core.rest.role.RoleCreateRequest;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class MeshRestClientErrorHandlingTest
extends AbstractMeshTest {
    @Before
    public void setUp() throws Exception {
        this.client().logout();
    }

    @Test
    public void testBlockingGet() {
        this.expectError(403, () -> this.forbiddenRequest().blockingGet());
    }

    @Test
    public void testBlockingAwait() {
        this.expectError(403, () -> this.forbiddenRequest().blockingAwait());
    }

    @Test
    public void testToCompletable() {
        this.expectError(403, () -> this.forbiddenRequest().toCompletable().blockingAwait());
    }

    @Test
    public void testToSingle() {
        this.expectError(403, () -> this.forbiddenRequest().toSingle().blockingGet());
    }

    @Test
    public void testToMaybe() {
        this.expectError(403, () -> this.forbiddenRequest().toMaybe().blockingGet());
    }

    @Test
    public void testToObservable() {
        this.expectError(403, () -> this.forbiddenRequest().toObservable().blockingFirst());
    }

    @Test
    public void testToFlowable() {
        this.expectError(403, () -> this.forbiddenRequest().toFlowable().blockingFirst());
    }

    private MeshRequest<RoleResponse> forbiddenRequest() {
        return this.client().createRole(new RoleCreateRequest().setName("forbiddenRole"));
    }

    private void expectError(int status, Runnable runnable) {
        try {
            runnable.run();
            Assert.fail();
        }
        catch (Throwable err) {
            Assertions.assertThat((Throwable)err).hasCauseInstanceOf(MeshRestClientMessageException.class);
            Assertions.assertThat((int)((MeshRestClientMessageException)err.getCause()).getStatusCode()).isEqualTo(status);
        }
    }
}

