/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.client;

import com.gentics.mesh.core.rest.common.RestModel;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class MeshRestClientTest
extends AbstractMeshTest {
    @Test
    public void testGenericGet() {
        JsonObject users = (JsonObject)ClientHelper.call(() -> this.client().get("/users"));
        Assert.assertNotNull((Object)users.getJsonArray("data"));
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().get("/users", UserListResponse.class));
        Assert.assertTrue((list.getData().size() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGenericPost() {
        JsonObject userJson = new JsonObject();
        userJson.put("username", (Object)"joedoe123");
        userJson.put("password", (Object)"finger123");
        JsonObject json2 = (JsonObject)ClientHelper.call(() -> this.client().post("/users", userJson));
        Assert.assertEquals((Object)"joedoe123", (Object)json2.getString("username"));
        UserCreateRequest userCreateRequest = new UserCreateRequest();
        userCreateRequest.setUsername("joedoe2");
        userCreateRequest.setPassword("finger1234");
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().post("/users", (RestModel)userCreateRequest, UserResponse.class));
        Assert.assertEquals((Object)"joedoe2", (Object)response.getUsername());
    }

    @Test
    @Ignore
    public void testGenericPut() {
        JsonObject json = (JsonObject)ClientHelper.call(() -> this.client().put("/test"));
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().put("/users", UserResponse.class));
        JsonObject userJson = new JsonObject();
        JsonObject json2 = (JsonObject)ClientHelper.call(() -> this.client().put("/users", userJson));
        UserCreateRequest userCreateRequest = new UserCreateRequest();
        userCreateRequest.setUsername("joedoe2");
        ClientHelper.call(() -> this.client().put("/users", (RestModel)userCreateRequest, UserResponse.class));
    }

    @Test
    public void testGenericDelete() {
        UserCreateRequest userCreateRequest = new UserCreateRequest();
        userCreateRequest.setUsername("joedoe2");
        userCreateRequest.setPassword("finger1234");
        String userUuid2 = ((UserResponse)ClientHelper.call(() -> this.client().createUser(userCreateRequest, new ParameterProvider[0]))).getUuid();
        ClientHelper.call(() -> this.client().deleteEmpty("/users/" + userUuid2));
    }
}

