/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.client;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.user.UserAPITokenResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.demo.UserInfo;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestDataProvider;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Flowable;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.NONE, testSize=TestSize.PROJECT, startServer=true, customOptionChanger=SetTokenExpirationTime.class)
public class MeshRestClientTokenTest
extends AbstractMeshTest {
    public static final int TOKEN_EXPIRATION_TIME_SECONDS = 5;
    private String testUserApiToken;
    private String username;
    private String password;

    @Before
    public void setUp() throws Exception {
        String userUuid = TestDataProvider.getInstance().getUserInfo().getUserUuid();
        this.testUserApiToken = ((UserAPITokenResponse)testContext.getHttpClient().issueAPIToken(userUuid).blockingGet()).getToken();
        UserInfo userInfo = TestDataProvider.getInstance().getUserInfo();
        this.username = (String)this.tx(tx -> userInfo.getUser().getUsername());
        this.password = userInfo.getPassword();
        this.client().logout().blockingGet();
    }

    @Test
    public void testLogin() throws Exception {
        this.client().setLogin(this.username, this.password).login().blockingGet();
        Flowable.intervalRange((long)0L, (long)10L, (long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).flatMapSingle(v -> this.client().me(new ParameterProvider[0]).toSingle()).doOnNext(response -> MeshAssertions.assertThat((UserResponse)response).hasName(this.username)).blockingSubscribe();
    }

    @Test
    public void testApiToken() throws Exception {
        UserInfo userInfo = TestDataProvider.getInstance().getUserInfo();
        String username = (String)this.tx(tx -> userInfo.getUser().getUsername());
        this.client().setAPIKey(this.testUserApiToken);
        Flowable.intervalRange((long)0L, (long)10L, (long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).flatMapSingle(v -> this.client().me(new ParameterProvider[0]).toSingle()).doOnNext(response -> {
            MeshAssertions.assertThat((UserResponse)response).hasName(username);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)this.client().getAPIKey()).as("API Token", new Object[0])).isEqualTo((Object)this.testUserApiToken);
        }).blockingSubscribe();
    }

    @Test
    public void testExpiration() throws Exception {
        this.client().setLogin(this.username, this.password).login().blockingGet();
        Thread.sleep(6000L);
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED);
    }

    public static class SetTokenExpirationTime
    implements MeshOptionChanger {
        public void change(MeshOptions options) {
            options.getAuthenticationOptions().setTokenExpirationTime(5);
        }
    }
}

