/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core;

import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.NONE, testSize=TestSize.FULL, startServer=true)
public class ApiVersionTest
extends AbstractMeshTest {
    private void expectFailure(String version) throws IOException {
        this.assertFailure(this.httpGetNowJson(String.format("/api/%s/users", version), new ParameterProvider[0]), "error_version_not_found", version, "v2");
    }

    @Test
    public void testInvalidVersion() throws IOException {
        this.expectFailure("bogus");
    }

    @Test
    public void testTooLargeVersion() throws IOException {
        this.expectFailure("v99999999999999999999999999");
    }

    @Test
    public void testFutureVersion() throws IOException {
        this.expectFailure("v3");
    }
}

