/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core;

import com.gentics.mesh.BuildInfo;
import com.gentics.mesh.Mesh;
import com.gentics.mesh.MeshVersion;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class MeshRootTest
extends AbstractMeshTest {
    @Test
    public void testResolvePath() throws InterruptedException {
        try (Tx tx = this.tx();){
            this.expectSuccess("projects", tx.data().permissionRoots().project());
            this.expectSuccess("projects/" + this.project().getUuid(), (HibBaseElement)this.project());
            this.expectSuccess("projects/" + this.project().getUuid() + "/schemas", this.project().getSchemaPermissionRoot());
            this.expectSuccess("projects/" + this.project().getUuid() + "/schemas/" + this.schemaContainer("folder").getUuid(), (HibBaseElement)this.schemaContainer("folder"));
            this.expectSuccess("projects/" + this.project().getUuid() + "/tagFamilies", this.project().getTagFamilyPermissionRoot());
            this.expectSuccess("projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid(), (HibBaseElement)this.tagFamily("colors"));
            this.expectSuccess("projects/" + this.project().getUuid() + "/nodes", this.project().getNodePermissionRoot());
            this.expectSuccess("projects/" + this.project().getUuid() + "/nodes/" + this.folder("2015").getUuid(), (HibBaseElement)this.folder("2015"));
            this.expectSuccess("projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid() + "/tags", (HibBaseElement)this.tagFamily("colors"));
            this.expectSuccess("projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid() + "/tags/" + this.tag("red").getUuid(), (HibBaseElement)this.tag("red"));
            this.expectSuccess("users", tx.data().permissionRoots().user());
            this.expectSuccess("users/" + this.user().getUuid(), (HibBaseElement)this.user());
            this.expectSuccess("roles", tx.data().permissionRoots().role());
            this.expectSuccess("roles/" + this.role().getUuid(), (HibBaseElement)this.role());
            this.expectSuccess("groups", tx.data().permissionRoots().group());
            this.expectSuccess("groups/" + this.group().getUuid(), (HibBaseElement)this.group());
            this.expectSuccess("schemas", tx.data().permissionRoots().schema());
            this.expectSuccess("schemas/" + this.schemaContainer("folder").getUuid(), (HibBaseElement)this.schemaContainer("folder"));
            this.expectFailure("");
            this.expectFailure(null);
            this.expectFailure("bogus");
            this.expectFailure("/////////");
            this.expectFailure("/1/2/3/4/5/6/7");
            this.expectFailure("projects/");
            this.expectFailure("projects/bogus");
            this.expectFailure("projects/bogus/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/tagFamilies/");
            this.expectFailure("projects/" + this.project().getUuid() + "/tagFamilies/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid() + "/");
            this.expectFailure("projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid() + "/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/nodes/");
            this.expectFailure("projects/" + this.project().getUuid() + "/nodes/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/nodes/" + this.folder("2015").getUuid() + "/");
            this.expectFailure("projects/" + this.project().getUuid() + "/nodes/" + this.folder("2015").getUuid() + "/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/tags/");
            this.expectFailure("projects/" + this.project().getUuid() + "/tags/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/tags/" + this.folder("2015").getUuid() + "/");
            this.expectFailure("projects/" + this.project().getUuid() + "/tags/" + this.folder("2015").getUuid() + "/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/schemas/");
            this.expectFailure("projects/" + this.project().getUuid() + "/schemas/bogus");
            this.expectFailure("projects/" + this.project().getUuid() + "/schemas/" + this.schemaContainer("folder").getUuid() + "/");
            this.expectFailure("projects/" + this.project().getUuid() + "/schemas/" + this.schemaContainer("folder").getUuid() + "/bogus");
            this.expectFailure("users/");
            this.expectFailure("users/bogus");
            this.expectFailure("groups/");
            this.expectFailure("groups/bogus");
            this.expectFailure("roles/");
            this.expectFailure("roles/bogus");
            this.expectFailure("schemas/");
            this.expectFailure("schemas/bogus");
        }
    }

    public void testCheckVersion() throws IOException {
        this.setMeshVersions("1.0.0", "1.0.0");
        this.boot().handleMeshVersion();
        this.boot().handleMeshVersion();
        this.setMeshVersions("1.0.0", "1.0.1");
        this.boot().handleMeshVersion();
        this.boot().handleMeshVersion();
        this.setMeshVersions("1.0.0-SNAPSHOT", "1.0.0-SNAPSHOT");
        this.boot().handleMeshVersion();
        this.boot().handleMeshVersion();
        this.setMeshVersions("1.0.1", "1.0.0");
        this.setDatabaseRev(this.db().getDatabaseRevision());
        this.boot().handleMeshVersion();
        this.setMeshVersions("1.0.1", "1.0.0");
        this.setDatabaseRev("different");
        this.expectException(() -> this.boot().handleMeshVersion());
        this.setMeshVersions("1.0.0-SNAPSHOT", "1.0.0");
        this.expectException(() -> this.boot().handleMeshVersion());
        this.setMeshVersions("1.0.0", "1.0.0-SNAPSHOT");
        this.expectException(() -> this.boot().handleMeshVersion());
        System.setProperty("ignoreSnapshotUpgradeCheck", "true");
        this.setMeshVersions("1.0.0-SNAPSHOT", "1.0.0");
        this.boot().handleMeshVersion();
    }

    private void setDatabaseRev(String rev) {
        try (Tx tx = this.tx();){
            tx.data().meshVersion().setDatabaseRevision(rev);
            tx.success();
        }
    }

    private void setMeshVersions(String graphVersion, String buildVersion) throws IOException {
        MeshVersion.buildInfo.set(new BuildInfo(buildVersion, null));
        Assert.assertEquals((Object)buildVersion, (Object)Mesh.getPlainVersion());
        try (Tx tx = this.tx();){
            tx.data().meshVersion().setMeshVersion(graphVersion);
            tx.success();
        }
    }

    private void expectException(Runnable action) {
        try {
            action.run();
            Assert.fail((String)"An exception should have been thrown.");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)("We did not expect the message {" + msg + "}"), (boolean)msg.startsWith("Downgrade not allowed"));
        }
    }

    @Deprecated
    private void expectSuccess(String path, HibBaseElement vertex) throws InterruptedException {
        HibBaseElement resolvedVertex = this.resolve(path);
        Assert.assertNotNull((String)("We expected that the path {" + path + "} could be resolved but resolving failed."), (Object)resolvedVertex);
        Assert.assertEquals((Object)vertex.getUuid(), (Object)resolvedVertex.getUuid());
    }

    private void expectFailure(String path) throws InterruptedException {
        boolean error = false;
        try {
            HibBaseElement vertex = this.resolve(path);
            Assert.assertNull((String)("We expected that the path {" + path + "} can't be resolved successfully but it was."), (Object)vertex);
            error = true;
        }
        catch (Exception e) {
            error = true;
        }
        if (!error) {
            Assert.fail((String)("No exception occured but we expected an error while resolving path {" + path + "}"));
        }
    }

    private HibBaseElement resolve(String pathToElement) throws InterruptedException {
        return this.boot().rootResolver().resolvePathToElement(pathToElement);
    }
}

