/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core;

import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class MultithreadGraphTest
extends AbstractMeshTest {
    @Test
    public void testMultithreading() throws InterruptedException {
        this.runAndWait(() -> {
            try (Tx tx = this.tx();){
                UserDao userDao = tx.userDao();
                HibUser user = userDao.create("test", null);
                user.setCreated(this.user());
                Assert.assertNotNull((Object)user);
                tx.success();
            }
            System.out.println("Created user");
        });
        this.runAndWait(() -> {
            try (Tx tx = this.tx();){
                this.runAndWait(() -> {
                    HibUser user = tx.userDao().findByUsername("test");
                    Assert.assertNotNull((Object)user);
                });
                HibUser user = tx.userDao().findByUsername("test");
                Assert.assertNotNull((Object)user);
                System.out.println("Read user");
            }
        });
        try (Tx tx = this.tx();){
            HibUser user = tx.userDao().findByUsername("test");
            Assert.assertNotNull((Object)user);
        }
    }

    public void runAndWait(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Done waiting");
    }
}

