/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core;

import com.gentics.mesh.core.data.HibNamedElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.error.MeshSchemaException;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NamedEntityDuplicationTest
extends AbstractMeshTest {
    @Test(expected=RuntimeException.class)
    public void testDuplicateProject() {
        this.testDuplicate("project", (name, tx) -> tx.projectDao().create(name, "localhost", Boolean.valueOf(false), "", this.user(), (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion(), this.data().createBatch()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateRole() {
        this.testDuplicate("role", (name, tx) -> tx.roleDao().create(name, this.user()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateBranch() {
        this.testDuplicate("branch", (name, tx) -> tx.branchDao().create(this.project(), name, this.user(), this.data().createBatch()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateTag() {
        this.testDuplicate("tag", (name, tx) -> tx.tagDao().create(this.tagFamily("colors"), name, this.project(), this.user()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateTagFamily() {
        this.testDuplicate("tagfamily", (name, tx) -> tx.tagFamilyDao().create(this.project(), name, this.user()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateGroup() {
        this.testDuplicate("group", (name, tx) -> tx.groupDao().create(name, this.user()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateLanguage() {
        this.testDuplicate("language", (name, tx) -> tx.languageDao().create(name, "lng"));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateUser() {
        this.testDuplicate("user", (name, tx) -> tx.userDao().create(name, this.user()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateSchema() {
        this.testDuplicate("schema", (name, tx) -> {
            try {
                return tx.schemaDao().create((SchemaVersionModel)new SchemaModelImpl().setName(name), this.user());
            }
            catch (MeshSchemaException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateMicroschema() {
        this.testDuplicate("microschema", (name, tx) -> tx.microschemaDao().create(new MicroschemaModelImpl().setName(name), this.user(), this.data().createBatch()));
    }

    protected <E extends HibNamedElement> void testDuplicate(String entityName, BiFunction<String, Tx, E> creator) {
        String name = entityName + "_" + Long.toHexString(System.currentTimeMillis());
        this.tx(tx -> {
            HibNamedElement entity = (HibNamedElement)creator.apply(name, tx);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)name, (Object)entity.getName());
            entity = (HibNamedElement)creator.apply(name, tx);
        });
    }
}

