/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core;

import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class OtherTypeUuidTest
extends AbstractMeshTest {
    private String colorsUuid;
    private ProjectResponse otherProject;
    private String planeUuid;

    @Before
    public void setUp() throws Exception {
        this.colorsUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        this.planeUuid = (String)this.tx(() -> this.tag("plane").getUuid());
        this.otherProject = this.createProject("testProject");
    }

    @Test
    public void testNode() {
        this.expect404(this.client().findNodeByUuid("dummy", this.projectUuid(), new ParameterProvider[0]), this.projectUuid());
    }

    @Test
    public void testNodeFromOtherProject() {
        this.expect404(this.client().findNodeByUuid(this.otherProject.getName(), this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testProject() {
        this.expect404(this.client().findProjectByUuid(this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testSchema() {
        this.expect404(this.client().findSchemaByUuid(this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testMicroschema() {
        this.expect404(this.client().findMicroschemaByUuid(this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testTagFamily() {
        this.expect404(this.client().findTagFamilyByUuid("dummy", this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testTagFamilyFromOtherProject() {
        this.expect404(this.client().findTagFamilyByUuid(this.otherProject.getName(), this.colorsUuid, new ParameterProvider[0]), this.colorsUuid);
    }

    @Test
    public void testTag() {
        this.expect404(this.client().findTagByUuid("dummy", this.colorsUuid, this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testTagFromOtherFamily() {
        this.expect404(this.client().findTagByUuid("dummy", this.colorsUuid, this.planeUuid, new ParameterProvider[0]), this.planeUuid);
    }

    @Test
    public void testUser() {
        this.expect404(this.client().findUserByUuid(this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testGroup() {
        this.expect404(this.client().findGroupByUuid(this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testRole() {
        this.expect404(this.client().findRoleByUuid(this.folderUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testLinkRendering() {
        String resolvedLink = (String)this.client().resolveLinks("{{mesh.link('" + this.projectUuid() + "')}}", new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}).blockingGet();
        Assertions.assertThat((String)resolvedLink).isEqualTo((Object)"/error/404");
    }

    @Test
    public void testGraphQL() {
        GraphQLRequest request = new GraphQLRequest().setQuery("query nodeByUuid($uuid:String) {\n  node(uuid: $uuid) {\n    uuid\n  }\n}").setVariables(new JsonObject().put("uuid", (Object)this.projectUuid()));
        GraphQLResponse graphQLResponse = (GraphQLResponse)this.client().graphql("dummy", request, new ParameterProvider[0]).blockingGet();
        Assertions.assertThat((Iterable)graphQLResponse.getData().getJsonObject("node")).isNull();
    }

    private void expect404(MeshRequest<?> request) {
        this.expect404(request, this.folderUuid());
    }

    private void expect404(MeshRequest<?> request, String uuid) {
        ClientHelper.call(() -> request, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{uuid});
    }
}

