/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.core.rest.MeshServerInfoModel;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.impl.launcher.commands.VersionCommand;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class RestInfoEndpointTest
extends AbstractMeshTest {
    @Test
    public void testGetInfoWithDisabledServerTokens() {
        this.options().getHttpServerOptions().setServerTokens(false);
        MeshServerInfoModel info = (MeshServerInfoModel)ClientHelper.call(() -> this.client().getApiInfo());
        Assert.assertNull((Object)info.getMeshVersion());
        this.grantAdmin();
        info = (MeshServerInfoModel)ClientHelper.call(() -> this.client().getApiInfo());
        Assert.assertNotNull((Object)info.getMeshVersion());
    }

    @Test
    public void testGetInfo() {
        MeshServerInfoModel info = (MeshServerInfoModel)ClientHelper.call(() -> this.client().getApiInfo());
        Assert.assertEquals((Object)Mesh.getPlainVersion(), (Object)info.getMeshVersion());
        Assert.assertEquals((Object)"dev-null", (Object)info.getSearchVendor());
        Assert.assertEquals((Object)VersionCommand.getVersion(), (Object)info.getVertxVersion());
        Assert.assertEquals((Object)this.options().getNodeName(), (Object)info.getMeshNodeName());
        Assert.assertEquals((Object)"1.0", (Object)info.getSearchVersion());
        Assert.assertEquals((Object)this.db().getDatabaseRevision(), (Object)info.getDatabaseRevision());
    }

    @Test
    public void testLoadRAML() {
        this.grantAdmin();
        String raml = (String)ClientHelper.call(() -> this.client().getRAML());
        Assert.assertNotNull((Object)raml);
    }
}

