/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.admin;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.plugin.PluginDeploymentRequest;
import com.gentics.mesh.core.rest.plugin.PluginListResponse;
import com.gentics.mesh.core.rest.plugin.PluginResponse;
import com.gentics.mesh.core.rest.plugin.PluginStatus;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.plugin.AbstractPluginTest;
import com.gentics.mesh.plugin.ClonePlugin;
import com.gentics.mesh.plugin.ManifestInjectorPlugin;
import com.gentics.mesh.plugin.PluginManifest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.PluginTests;
import com.gentics.mesh.test.helper.ExpectedEvent;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractIntegerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={PluginTests.class})
@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true, inMemoryDB=true)
public class AdminPluginEndpointTest
extends AbstractPluginTest {
    private static final String API_NAME = "basic";

    @Test
    public void testDeployPluginMissingPermission() throws IOException {
        this.revokeAdmin();
        this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar", HttpResponseStatus.FORBIDDEN, "error_admin_permission_required", new String[0]);
    }

    @Test
    public void testReadPluginMissingPermission() throws IOException {
        this.grantAdmin();
        PluginResponse deployment = this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        this.revokeAdmin();
        String id = deployment.getId();
        ClientHelper.call(() -> this.client().findPlugin(id), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
    }

    @Test
    public void testNonPluginDeployment() throws IOException {
        this.grantAdmin();
        String name = "non-mesh.jar";
        int before = this.meshApi().pluginIds().size();
        this.copyAndDeploy("/test-plugins/non-mesh/target/non-mesh-plugin-0.0.1-SNAPSHOT.jar", name, HttpResponseStatus.INTERNAL_SERVER_ERROR, "admin_plugin_error_plugin_loading_failed", name);
        int after = this.meshApi().pluginIds().size();
        Assert.assertEquals((String)"The verticle should not stay deployed.", (long)before, (long)after);
    }

    @Test
    public void testUndeployPluginMissingPermission() throws IOException {
        this.grantAdmin();
        PluginResponse deployment = this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        this.revokeAdmin();
        String id = deployment.getId();
        ClientHelper.call(() -> this.client().undeployPlugin(id), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
    }

    @Test
    public void testUndeployBogusPlugin() {
        this.grantAdmin();
        String id = "bogus";
        ClientHelper.call(() -> this.client().undeployPlugin(id), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{id});
    }

    @Test
    public void testReadPluginListMissingPermission() {
        this.revokeAdmin();
        ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
    }

    @Test
    public void testDeployPlugin() throws IOException {
        this.grantAdmin();
        PluginResponse deployment = this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "basic-plugin.jar");
        Assert.assertEquals((Object)API_NAME, (Object)deployment.getId());
        Assert.assertEquals((Object)PluginStatus.REGISTERED, (Object)deployment.getStatus());
        this.waitForEvent(MeshEvent.PLUGIN_REGISTERED);
        PluginResponse response1 = (PluginResponse)ClientHelper.call(() -> this.client().findPlugin(deployment.getId()));
        Assert.assertEquals((Object)PluginStatus.REGISTERED, (Object)response1.getStatus());
        Assert.assertEquals((Object)"world", (Object)this.httpGetNow("/api/v2/plugins/basic/hello", new ParameterProvider[0]));
        Assert.assertEquals((Object)"world-project", (Object)this.httpGetNow("/api/v2/dummy/plugins/basic/hello", new ParameterProvider[0]));
        PluginListResponse list = (PluginListResponse)ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)list.getMetainfo().getTotalCount());
        PluginResponse response2 = (PluginResponse)ClientHelper.call(() -> this.client().findPlugin(deployment.getId()));
        Assert.assertEquals((Object)deployment.getName(), (Object)response2.getName());
        ClientHelper.call(() -> this.client().undeployPlugin(deployment.getId()));
        Assert.assertEquals((long)404L, (long)this.httpGet("/api/v2/plugins/basic/hello", new ParameterProvider[0]).execute().code());
    }

    @Test
    public void testPluginList() throws IOException {
        this.grantAdmin();
        PluginResponse response = this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        Assert.assertEquals((long)1L, (long)this.pluginManager().getPluginIds().size());
        String bogusName = "bogus.jar";
        ClientHelper.call(() -> this.client().deployPlugin(new PluginDeploymentRequest().setPath(bogusName)), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"admin_plugin_error_plugin_deployment_failed", (String[])new String[]{bogusName});
        PluginResponse response2 = (PluginResponse)ClientHelper.call(() -> this.client().findPlugin(response.getId()));
        Assert.assertEquals((Object)response.getId(), (Object)response2.getId());
        ClientHelper.call(() -> this.client().findPlugin("bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"admin_plugin_error_plugin_not_found", (String[])new String[]{"bogus"});
        PluginListResponse pluginList = (PluginListResponse)ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[0]));
        Assert.assertNull((Object)pluginList.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getPageCount());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getTotalCount());
        PluginResponse first = (PluginResponse)pluginList.getData().get(0);
        Assert.assertEquals((String)"The id of the plugin did not match", (Object)API_NAME, (Object)first.getId());
        pluginList = (PluginListResponse)ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(1L))}));
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getPageCount());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getTotalCount());
        GenericMessageResponse msg = (GenericMessageResponse)ClientHelper.call(() -> this.client().undeployPlugin(response.getId()));
        MeshAssertions.assertThat((GenericMessageResponse)msg).matches("admin_plugin_undeployed", new String[]{response.getId()});
        pluginList = (PluginListResponse)ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(1L))}));
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)pluginList.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)0L, (long)pluginList.getMetainfo().getPageCount());
        Assert.assertEquals((long)0L, (long)pluginList.getMetainfo().getTotalCount());
    }

    @Test
    public void testStaticHandler() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        this.copyAndDeploy("/test-plugins/basic2/target/basic2-plugin-0.0.1-SNAPSHOT.jar", "plugin2.jar");
        this.waitForPluginRegistration();
        Assert.assertEquals((Object)"world", (Object)this.httpGetNow("/api/v2/plugins/basic/hello", new ParameterProvider[0]));
        Assert.assertEquals((Object)"world2", (Object)this.httpGetNow("/api/v2/plugins/basic2/hello", new ParameterProvider[0]));
        Assert.assertEquals((Object)"content", (Object)this.httpGetNow("/api/v2/plugins/basic/static/file.txt", new ParameterProvider[0]));
        Assert.assertEquals((Object)"content2", (Object)this.httpGetNow("/api/v2/plugins/basic2/static2/file.txt", new ParameterProvider[0]));
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)this.httpGet("/api/v2/plugins/basic/static/nonexistent.txt", new ParameterProvider[0]).execute().code()).as("Response code for nonexistent.txt", new Object[0])).isEqualTo(404);
    }

    @Test
    public void testStaticHandlerRedeploy() throws IOException, TimeoutException {
        this.grantAdmin();
        try (ExpectedEvent ee = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 10000);){
            this.copyAndDeploy("/test-plugins/static/target/static-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        }
        Assert.assertEquals((Object)"before change", (Object)this.httpGetNow("/api/v2/plugins/static/static/changed.txt", new ParameterProvider[0]));
        Assert.assertEquals((Object)"removed", (Object)this.httpGetNow("/api/v2/plugins/static/static/removed.txt", new ParameterProvider[0]));
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)this.httpGet("/api/v2/plugins/static/static/added.txt", new ParameterProvider[0]).execute().code()).as("Response code for added.txt", new Object[0])).isEqualTo(404);
        ClientHelper.call(() -> this.client().undeployPlugin("static"));
        ee = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 10000);
        try {
            this.copyAndDeploy("/test-plugins/static2/target/static2-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        }
        finally {
            if (ee != null) {
                ee.close();
            }
        }
        Assert.assertEquals((Object)"after change", (Object)this.httpGetNow("/api/v2/plugins/static/static/changed.txt", new ParameterProvider[0]));
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)this.httpGet("/api/v2/plugins/static/static/removed.txt", new ParameterProvider[0]).execute().code()).as("Response code for removed.txt", new Object[0])).isEqualTo(404);
        Assert.assertEquals((Object)"added", (Object)this.httpGetNow("/api/v2/plugins/static/static/added.txt", new ParameterProvider[0]));
    }

    @Test
    public void testStaticHandlerAbsolutePluginDir() throws IOException, TimeoutException {
        this.grantAdmin();
        File pluginDir = new File(this.pluginDir());
        this.setPluginBaseDir(pluginDir.getAbsolutePath());
        try (ExpectedEvent ee = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 10000);){
            this.copyAndDeploy("/test-plugins/static/target/static-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        }
        Assert.assertEquals((Object)"before change", (Object)this.httpGetNow("/api/v2/plugins/static/static/changed.txt", new ParameterProvider[0]));
    }

    @Test
    public void testClassLoaderHandling() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/classloader/target/classloader-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        this.waitForPluginRegistration();
        Assert.assertEquals((Object)"plugin", (Object)this.httpGetNow("/api/v2/plugins/classloader/scope", new ParameterProvider[0]));
        Assert.assertEquals((Object)"plugin", (Object)this.httpGetNow("/api/v2/plugins/classloader/check", new ParameterProvider[0]));
    }

    @Test
    public void testInvalidManifest() throws IOException {
        ManifestInjectorPlugin.manifest = new PluginManifest().setAuthor("Joe Doe").setId("injector").setName("The injector test plugin").setInception("2018").setDescription("some Text").setLicense("Apache 2.0").setVersion(null);
        ManifestInjectorPlugin.apiName = "api";
        this.grantAdmin();
        this.deployPlugin(ManifestInjectorPlugin.class, "inject", HttpResponseStatus.BAD_REQUEST, "admin_plugin_error_validation_failed_field_missing", "version");
    }

    @Test
    public void testManifestWithInvalidAPIName() {
        ManifestInjectorPlugin.manifest = new PluginManifest().setId("injector").setName("Injector test plugin").setDescription("some Text").setAuthor("Joe Doe").setInception("2018").setLicense("Apache 2.0").setVersion("1.0");
        ManifestInjectorPlugin.apiName = "api with spaces";
        this.grantAdmin();
        this.deployPlugin(ManifestInjectorPlugin.class, "injector", HttpResponseStatus.BAD_REQUEST, "admin_plugin_error_validation_failed_apiname_invalid", "injector");
        ManifestInjectorPlugin.apiName = "api/with/slashes";
        this.deployPlugin(ManifestInjectorPlugin.class, "injector", HttpResponseStatus.BAD_REQUEST, "admin_plugin_error_validation_failed_apiname_invalid", "injector");
        ManifestInjectorPlugin.apiName = "ok";
        this.deployPlugin(ManifestInjectorPlugin.class, "injector");
    }

    @Test
    public void testMultipleDeployments() throws IOException {
        this.grantAdmin();
        for (int i = 1; i <= 100; ++i) {
            this.deployPlugin(ClonePlugin.class, "clone" + i);
        }
        this.waitForPluginRegistration();
        PluginListResponse result = (PluginListResponse)ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(10L)).setPage(10L)}));
        PluginResponse lastElement = (PluginResponse)result.getData().get(9);
        Assert.assertEquals((Object)"Clone Plugin 100", (Object)lastElement.getName());
        Assert.assertEquals((long)10L, (long)result.getMetainfo().getPerPage());
        Assert.assertEquals((long)10L, (long)result.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)10L, (long)result.getMetainfo().getPageCount());
        Assert.assertEquals((long)100L, (long)result.getMetainfo().getTotalCount());
        Assert.assertEquals((Object)"world", (Object)this.httpGetNow("/api/v2/plugins/clone100/hello", new ParameterProvider[0]));
    }

    @Test
    public void testDuplicateDeployment() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        Assert.assertEquals((long)1L, (long)this.pluginManager().getPluginIds().size());
        long before = this.pluginCount();
        this.copyAndDeploy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin2.jar", HttpResponseStatus.BAD_REQUEST, "admin_plugin_error_plugin_with_id_already_deployed", "plugin2.jar");
        Assert.assertEquals((String)"No additional plugins should have been deployed", (long)before, (long)this.pluginCount());
        Assert.assertEquals((long)1L, (long)this.pluginManager().getPluginIds().size());
    }

    @Test
    public void testExtensionHandling() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/extension-consumer/target/extension-consumer-plugin-0.0.1-SNAPSHOT.jar", "extension-consumer.jar");
        this.copyAndDeploy("/test-plugins/extension-provider/target/extension-provider-plugin-0.0.1-SNAPSHOT.jar", "extension-provider.jar");
        this.waitForPluginRegistration();
        Assert.assertEquals((Object)"My dummy extension\n", (Object)this.httpGetNow("/api/v2/plugins/extension-consumer/extensions", new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().undeployPlugin("extension-provider"));
        Assert.assertEquals((Object)"", (Object)this.httpGetNow("/api/v2/plugins/extension-consumer/extensions", new ParameterProvider[0]));
    }

    @Test
    public void testClientPlugin() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/client/target/client-plugin-0.0.1-SNAPSHOT.jar", "client.jar");
        Assert.assertEquals((long)1L, (long)this.pluginManager().getPluginIds().size());
        Assert.assertNotNull((String)"Should find a default John Doe user", (Object)JsonUtil.readValue((String)this.httpGetNow("/api/v2/plugins/client/me", new ParameterProvider[0]), UserResponse.class));
    }
}

