/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.admin;

import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class DebugInfoTest
extends AbstractMeshTest {
    @Test
    public void testAsAnonymous() {
        ClientHelper.call(() -> this.client().debugInfo(new String[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
    }

    @Test
    public void testDefaultContents() throws Exception {
        DebugInfo info = this.getDebugInfo(new String[0]);
        Stream.of("log.txt", "localConfig.json", "config/hazelcast.xml", "config/orientdb-server-config.xml", "activeConfig.json", "clusterStatus.json", "searchStatus.json", "binaryDiskUsage.json", "threaddump.txt", "versions.json", "plugins.json", "systemInfo.json", "entities/projects.json", "entities/branches/dummy.json", "entities/schemas.json", "entities/microschemas.json", "entities/jobs.json", "migrationStatus/dummy/dummy/schemas.json", "migrationStatus/dummy/dummy/microschemas.json").forEach(info::assertExistence);
        ProjectResponse[] projects = info.getPojo("entities/projects.json", ProjectResponse[].class);
        Assertions.assertThat((int)projects.length).isEqualTo(1);
        Assertions.assertThat((String)projects[0].getName()).isEqualTo((Object)"dummy");
    }

    @Test
    public void testInclusions() throws IOException {
        DebugInfo info = this.getDebugInfo("consistencyCheck", "-log");
        Stream.of("localConfig.json", "consistencyCheck.json", "config/hazelcast.xml", "config/orientdb-server-config.xml", "activeConfig.json", "clusterStatus.json", "searchStatus.json", "binaryDiskUsage.json", "threaddump.txt", "versions.json", "plugins.json", "systemInfo.json", "entities/projects.json", "entities/branches/dummy.json", "entities/schemas.json", "entities/microschemas.json", "entities/jobs.json", "migrationStatus/dummy/dummy/schemas.json", "migrationStatus/dummy/dummy/microschemas.json").forEach(info::assertExistence);
    }

    private DebugInfo getDebugInfo(String ... includes) throws IOException {
        this.grantAdmin();
        MeshBinaryResponse response = (MeshBinaryResponse)this.client().debugInfo(includes).blockingGet();
        return new DebugInfo(response);
    }

    private class DebugInfo {
        private Map<String, byte[]> files = new HashMap<String, byte[]>();

        public DebugInfo(MeshBinaryResponse response) throws IOException {
            ZipEntry entry;
            ZipInputStream stream = new ZipInputStream(response.getStream());
            while ((entry = stream.getNextEntry()) != null) {
                String name = entry.getName();
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                this.files.put(name, bytes);
            }
        }

        public <T> T getPojo(String path, Class<T> clazz) {
            return (T)JsonUtil.readValue((String)new String(this.files.get(path), StandardCharsets.UTF_8), clazz);
        }

        public void assertExistence(String path) {
            Assertions.assertThat(this.files.keySet()).contains((Object[])new String[]{path});
        }
    }
}

