/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.admin;

import com.gentics.mesh.core.rest.admin.localconfig.LocalConfigModel;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Single;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.function.IntFunction;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class ReadOnlyModeTest
extends AbstractMeshTest {
    @After
    public void tearDown() {
        this.setReadOnly(false);
    }

    @Test
    public void testReadGraphQL() {
        Single request = this.client().graphqlQuery("dummy", "{ mesh { config { readOnly } } }", new ParameterProvider[0]).toSingle().map(response -> (Boolean)JsonPointer.from((String)"/mesh/config/readOnly").queryJson((Object)response.getData()));
        Assert.assertFalse((boolean)((Boolean)request.blockingGet()));
        this.setReadOnly(true);
        TestCase.assertTrue((boolean)((Boolean)request.blockingGet()));
        this.setReadOnly(false);
        Assert.assertFalse((boolean)((Boolean)request.blockingGet()));
    }

    @Test
    public void testReadRest() {
        Single request = this.client().loadLocalConfig().toSingle().map(LocalConfigModel::isReadOnly);
        Assert.assertFalse((boolean)((Boolean)request.blockingGet()));
        this.setReadOnly(true);
        TestCase.assertTrue((boolean)((Boolean)request.blockingGet()));
        this.setReadOnly(false);
        Assert.assertFalse((boolean)((Boolean)request.blockingGet()));
    }

    @Test
    public void testCreateUser() {
        this.testReadOnly(false, (int i) -> this.client().createUser(new UserCreateRequest().setUsername("test" + i).setPassword("abc"), new ParameterProvider[0]));
    }

    @Test
    public void testGraphQL() {
        this.testReadOnly(true, this.client().graphqlQuery("dummy", "{ me { uuid } }", new ParameterProvider[0]));
    }

    private void testReadOnly(boolean allowedInReadOnly, MeshRequest<?> request) {
        this.testReadOnly(allowedInReadOnly, (int ignore) -> request);
    }

    private void testReadOnly(boolean allowedInReadOnly, IntFunction<MeshRequest<?>> request) {
        request.apply(0).blockingAwait();
        this.setReadOnly(true);
        if (allowedInReadOnly) {
            request.apply(1).blockingAwait();
        } else {
            ClientHelper.call(() -> (MeshRequest)request.apply(1), (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED, (String)"error_readonly_mode", (String[])new String[0]);
        }
        this.setReadOnly(false);
        request.apply(2).blockingAwait();
    }

    private void setReadOnly(boolean readOnly) {
        ClientHelper.call(() -> this.client().updateLocalConfig(new LocalConfigModel().setReadOnly(Boolean.valueOf(readOnly))));
    }
}

