/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.binary;

import com.gentics.mesh.core.binary.DocumentTikaParser;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DocumentTikaParserTest {
    public static final int LIMIT = 40000;

    @Test
    public void testTika() throws TikaException, IOException {
        Buffer buffer = this.getBuffer("/testfiles/test.pdf");
        byte[] data = buffer.getBytes();
        Metadata metadata = new Metadata();
        String content = (String)DocumentTikaParser.parse((InputStream)new ByteArrayInputStream(data), (Metadata)metadata, (int)40000).get();
        System.out.println(content);
        System.out.println(metadata.toString());
    }

    protected Buffer getBuffer(String path) throws IOException {
        InputStream ins = this.getClass().getResourceAsStream(path);
        Assert.assertNotNull((String)("The resource for path {" + path + "} could not be found"), (Object)ins);
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        return Buffer.buffer((byte[])bytes);
    }

    @Test
    @Ignore
    public void testFilesInFolder() throws TikaException, IOException {
        File folder = new File("/media/ext4/tmp/dbfiles");
        for (int i = 0; i < 2; ++i) {
            for (File file : folder.listFiles()) {
                System.out.println("Testing: " + file.getName());
                try {
                    this.testParser(file);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.in.read();
                }
            }
        }
        System.out.println("Now testing PDF");
        this.testParser(new File("/media/ext4/tmp/SUP-10413.pdf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParser(File file) throws TikaException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            Metadata metadata = new Metadata();
            Optional op = DocumentTikaParser.parse((InputStream)fis, (Metadata)metadata, (int)40000);
            if (op.isPresent()) {
                String content = (String)op.get();
                System.out.println(content);
                System.out.println(metadata.toString());
            }
        }
    }
}

