/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.binary.impl;

import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.rest.client.MeshRestClientConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class FileUploadClientTest {
    public static final String PROJECT_NAME = "test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpload() throws IOException {
        MeshRestClientConfig config = MeshRestClientConfig.newConfig().setHost("mesh.test.gentics.com").setPort(80).setSsl(false).build();
        MeshRestClient client = MeshRestClient.create((MeshRestClientConfig)config);
        client.setLogin("admin", "admin");
        client.login().blockingGet();
        Optional<ProjectResponse> op = ((ProjectListResponse)client.findProjects(new ParameterProvider[0]).blockingGet()).getData().stream().filter(p -> p.getName().equalsIgnoreCase(PROJECT_NAME)).findFirst();
        if (op.isPresent()) {
            client.deleteProject(op.get().getUuid()).blockingAwait();
        }
        ProjectCreateRequest projectRequest = new ProjectCreateRequest();
        projectRequest.setName(PROJECT_NAME);
        projectRequest.setSchemaRef("folder");
        ProjectResponse project = (ProjectResponse)client.createProject(projectRequest).blockingGet();
        SchemaResponse schemaResponse = ((SchemaListResponse)client.findSchemas(new ParameterProvider[0]).blockingGet()).getData().stream().filter(schema -> schema.getName().equalsIgnoreCase("binary_content")).findFirst().get();
        String binaryContentSchemaUuid = schemaResponse.getUuid();
        client.assignSchemaToProject(PROJECT_NAME, binaryContentSchemaUuid).blockingGet();
        File folder = new File("/media/ext4/tmp/dbfiles");
        for (File file : folder.listFiles()) {
            try {
                NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
                nodeCreateRequest.setLanguage("en");
                nodeCreateRequest.setSchemaName("binary_content");
                nodeCreateRequest.setParentNodeUuid(project.getRootNode().getUuid());
                NodeResponse binaryNode = (NodeResponse)client.createNode(PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]).blockingGet();
                String nodeUuid = binaryNode.getUuid();
                try (FileInputStream ins = new FileInputStream(file);){
                    long len = file.length();
                    client.updateNodeBinaryField(PROJECT_NAME, nodeUuid, "en", "draft", "binary", (InputStream)ins, len, file.getName(), "application/pdf", new ParameterProvider[0]).blockingGet();
                }
            }
            catch (Throwable t) {
                System.out.println("Failure creating node for " + file.getName());
                t.printStackTrace();
            }
        }
    }
}

