/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.binary.impl;

import com.gentics.mesh.core.binary.BinaryDataProcessorContext;
import com.gentics.mesh.core.binary.impl.TikaBinaryProcessor;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.test.MeshOptionsTypeUnawareContext;
import dagger.Lazy;
import io.reactivex.Maybe;
import io.reactivex.functions.Function;
import io.vertx.ext.web.FileUpload;
import io.vertx.reactivex.core.Vertx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TikaBinaryProcessorTest
implements MeshOptionsTypeUnawareContext {
    @Test
    public void tikaCachingTest() throws FileNotFoundException, IOException {
        Lazy lazy = (Lazy)Mockito.mock(Lazy.class);
        Mockito.when((Object)((Vertx)lazy.get())).thenReturn((Object)Vertx.vertx());
        TikaBinaryProcessor processor = new TikaBinaryProcessor(lazy, this.getOptions(), this.mockDb());
        FileUpload ul = this.mockUpload("test.pdf", "application/pdf");
        Maybe result = processor.process(new BinaryDataProcessorContext(null, null, null, ul, "HASHSUM"));
        Consumer consumer = (Consumer)result.blockingGet();
        HibBinaryField field = (HibBinaryField)Mockito.mock(HibBinaryField.class);
        consumer.accept(field);
    }

    @Test
    @Ignore
    public void testFilesInFolder() throws IOException {
        File folder = new File("/media/ext4/tmp/dbfiles");
        Lazy lazy = (Lazy)Mockito.mock(Lazy.class);
        Mockito.when((Object)((Vertx)lazy.get())).thenReturn((Object)Vertx.vertx());
        TikaBinaryProcessor processor = new TikaBinaryProcessor(lazy, this.getOptions(), this.mockDb());
        for (int i = 0; i < 2; ++i) {
            for (File file : folder.listFiles()) {
                System.out.println("Testing: " + file.getName());
                try {
                    this.testParser(processor, file);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.in.read();
                }
            }
        }
        System.out.println("Now testing PDF");
        this.testParser(processor, new File("/media/ext4/tmp/SUP-10413.pdf"));
    }

    private void testParser(TikaBinaryProcessor processor, File file) {
        FileUpload ul = (FileUpload)Mockito.mock(FileUpload.class);
        Mockito.when((Object)ul.uploadedFileName()).thenReturn((Object)file.getAbsolutePath());
        Mockito.when((Object)ul.contentType()).thenReturn((Object)"application/pdf");
        Maybe result = processor.process(new BinaryDataProcessorContext(null, null, null, ul, "HASHSUM"));
        Consumer consumer = (Consumer)result.blockingGet();
        HibBinaryField field = (HibBinaryField)Mockito.mock(HibBinaryField.class);
        consumer.accept(field);
    }

    private Database mockDb() {
        Database mock = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)mock.maybeTx((Function)ArgumentMatchers.any())).thenReturn((Object)Maybe.empty());
        return mock;
    }

    private FileUpload mockUpload(String name, String contentType) throws FileNotFoundException, IOException {
        FileUpload ul = (FileUpload)Mockito.mock(FileUpload.class);
        File target = new File("target", "testupload.pdf");
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/testfiles/" + name), (OutputStream)new FileOutputStream(target));
        Mockito.when((Object)ul.uploadedFileName()).thenReturn((Object)target.getAbsolutePath());
        Mockito.when((Object)ul.contentType()).thenReturn((Object)contentType);
        return ul;
    }
}

