/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.branch;

import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.BranchDao;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BranchEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String etag = ClientHelper.callETag(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
            Assert.assertNotNull((Object)etag);
            ClientHelper.callETag(() -> this.client().findBranches("dummy", new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findBranches("dummy", new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadOne() {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibBranch branch = this.project().getLatestBranch();
            String actualEtag = ClientHelper.callETag(() -> this.client().findBranchByUuid("dummy", branch.getUuid(), new ParameterProvider[0]));
            String etag = branchDao.getETag((HibTransformableElement)branch, this.mockActionContext());
            Assertions.assertThat((String)actualEtag).contains(new CharSequence[]{etag});
            Assertions.assertThat((String)ClientHelper.callETag(() -> this.client().findBranchByUuid("dummy", branch.getUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304)).contains(new CharSequence[]{etag});
            ClientHelper.callETag(() -> this.client().findBranchByUuid("dummy", branch.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findBranchByUuid("dummy", branch.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304);
        }
    }
}

