/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.branch;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.BranchAssert;
import com.gentics.mesh.assertj.impl.BranchResponseAssert;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.BranchDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.core.rest.branch.info.BranchInfoMicroschemaList;
import com.gentics.mesh.core.rest.branch.info.BranchInfoSchemaList;
import com.gentics.mesh.core.rest.branch.info.BranchMicroschemaInfo;
import com.gentics.mesh.core.rest.branch.info.BranchSchemaInfo;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.branch.BranchMicroschemaAssignModel;
import com.gentics.mesh.core.rest.event.branch.BranchSchemaAssignEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.event.project.ProjectBranchEventModel;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.SchemaUpdateParameters;
import com.gentics.mesh.parameter.client.GenericParametersImpl;
import com.gentics.mesh.parameter.client.NodeParametersImpl;
import com.gentics.mesh.parameter.client.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.SchemaUpdateParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.TestUtils;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BranchEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    public void testUpdateMultithreaded() throws Exception {
    }

    @Override
    @Test
    public void testReadByUuidMultithreaded() throws Exception {
        int nJobs = 200;
        try (Tx tx = this.tx();){
            String projectName = "dummy";
            String uuid = this.initialBranchUuid();
            Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findBranchByUuid(projectName, uuid, new ParameterProvider[0]).toCompletable()).blockingAwait();
        }
    }

    @Override
    public void testDeleteByUUIDMultithreaded() throws Exception {
    }

    @Override
    @Test
    @Ignore
    public void testCreateMultithreaded() throws Exception {
        String branchName = "Branch V";
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            int nJobs = 100;
            HashSet<BranchResponse> responseFutures = new HashSet<BranchResponse>();
            for (int i = 0; i < nJobs; ++i) {
                BranchCreateRequest request = new BranchCreateRequest();
                request.setName(branchName + i);
                responseFutures.add((BranchResponse)this.client().createBranch("dummy", request, new ParameterProvider[0]).blockingGet());
            }
            HashSet<String> uuids = new HashSet<String>();
            uuids.add(this.initialBranchUuid());
            for (BranchResponse response : responseFutures) {
                ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Response", new Object[0])).isNotNull();
                MeshAssertions.assertThat(uuids).as("Existing uuids", new Object[0]).doesNotContain((Object[])new String[]{response.getUuid()});
                uuids.add(response.getUuid());
            }
            HashSet<String> foundBranches = new HashSet<String>();
            HibBranch previousBranch = null;
            HibBranch branch = project.getInitialBranch();
            do {
                ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as("Branch", new Object[0])).isNotNull()).hasPrevious(previousBranch);
                MeshAssertions.assertThat(foundBranches).as("Existing uuids", new Object[0]).doesNotContain((Object[])new String[]{branch.getUuid()});
                foundBranches.add(branch.getUuid());
                previousBranch = branch;
            } while ((branch = (HibBranch)branch.getNextBranches().get(0)) != null);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)previousBranch).as("Latest Branch", new Object[0])).matches(project.getLatestBranch());
            MeshAssertions.assertThat(foundBranches).as("Found Branchs", new Object[0]).containsOnlyElementsOf(uuids);
        }
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        int nJobs = 200;
        try (Tx tx = this.tx();){
            Observable.range((int)1, (int)nJobs).flatMapCompletable(i -> this.client().findBranchByUuid("dummy", this.initialBranchUuid(), new ParameterProvider[0]).toCompletable()).blockingAwait();
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        String branchName = "Branch V1";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        this.expect(MeshEvent.BRANCH_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(branchName)).uuidNotNull());
        this.expect(MeshEvent.BRANCH_MIGRATION_START).one();
        this.expect(MeshEvent.BRANCH_MIGRATION_FINISHED).one();
        this.expect(MeshEvent.NODE_UPDATED).total(58L);
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Branch Response", new Object[0])).isNotNull()).hasName(branchName).isActive().isNotMigrated();
        }, JobStatus.COMPLETED, 1);
        this.awaitEvents();
        BranchListResponse branches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
        branches.getData().forEach(branch -> ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)branch).as("Branch " + branch.getName(), new Object[0])).isMigrated());
    }

    @Test
    public void testCreateWithPrefix() throws Exception {
        String branchName = "Branch V1";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        request.setPathPrefix("/blub");
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            Assert.assertEquals((Object)"/blub", (Object)response.getPathPrefix());
            ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Branch Response", new Object[0])).isNotNull()).hasName(branchName).isActive().isNotMigrated();
        }, JobStatus.COMPLETED, 1);
        BranchListResponse branches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
        branches.getData().forEach(branch -> ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)branch).as("Branch " + branch.getName(), new Object[0])).isMigrated());
    }

    @Override
    public void testCreateWithNoPerm() throws Exception {
        String branchName = "Branch V1";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibProject project = this.project();
            roleDao.grantPermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.projectUuid() + "/dummy", InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        String branchName = "Branch V1";
        String uuid = UUIDUtil.randomUUID();
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", uuid, request, new ParameterProvider[0]));
            ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Branch Response", new Object[0])).isNotNull()).hasName(branchName).isActive().isNotMigrated().hasUuid(uuid);
        }, JobStatus.COMPLETED, 1);
        BranchListResponse branchs = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(Long.MAX_VALUE))}));
        branchs.getData().forEach(branch -> ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)branch).as("Branch " + branch.getName(), new Object[0])).isMigrated());
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        String branchName = "Branch V1";
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            String uuid = this.user().getUuid();
            BranchUpdateRequest request = new BranchUpdateRequest();
            request.setName(branchName);
            ClientHelper.call(() -> this.client().updateBranch(project.getName(), uuid, request), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
        }
    }

    @Test
    public void testCreateWithoutName() throws Exception {
        ClientHelper.call(() -> this.client().createBranch("dummy", new BranchCreateRequest(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"branch_missing_name", (String[])new String[0]);
    }

    @Test
    public void testCreateWithConflictingName1() throws Exception {
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("dummy");
        ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"branch_conflicting_name", (String[])new String[]{"dummy"});
    }

    @Test
    public void testCreateWithConflictingName2() throws Exception {
        BranchCreateRequest request = new BranchCreateRequest();
        String branchName = "New Branch";
        request.setName(branchName);
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"branch_conflicting_name", (String[])new String[]{branchName});
    }

    @Test
    public void testCreateWithConflictingName3() throws Exception {
        String branchName = "New Branch";
        String newProjectName = "otherproject";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        ProjectCreateRequest createProject = new ProjectCreateRequest();
        createProject.setName(newProjectName);
        createProject.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ClientHelper.call(() -> this.client().createProject(createProject));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().createBranch(newProjectName, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
    }

    @Override
    public void testCreateReadDelete() throws Exception {
    }

    @Test
    public void testCreateWithHostname() {
        String branchName = "MyBranch";
        String hostname = "my.host";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        request.setHostname(hostname);
        request.setSsl(Boolean.valueOf(true));
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(branchName).hasHostname(hostname).hasSSL((Object)true);
        }, JobStatus.COMPLETED, 1);
    }

    @Test
    public void testCreateWithSsl() {
        String branchName = "MyBranch";
        Boolean ssl = true;
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        request.setSsl(ssl);
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(branchName).hasSsl(ssl);
        }, JobStatus.COMPLETED, 1);
    }

    @Test
    public void testCreateAsLatest() {
        BranchListResponse projectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
        MeshAssertions.assertThat(projectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("Latest branches", new Object[0]).hasSize(1);
        String branchName = "Latest";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(branchName).isLatest();
            BranchListResponse updatedProjectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
            ((AbstractListAssert)MeshAssertions.assertThat(updatedProjectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("New latest branches", new Object[0]).usingElementComparatorIgnoringFields(new String[]{"creator", "editor", "permissions", "rolePerms"})).containsOnly((Object[])new BranchResponse[]{response});
        }, JobStatus.COMPLETED, 1);
    }

    @Test
    public void testCreateNotAsLatest() {
        BranchListResponse projectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
        MeshAssertions.assertThat(projectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("Latest branches", new Object[0]).hasSize(1);
        BranchResponse latestBranch = projectBranches.getData().stream().filter(BranchResponse::getLatest).findFirst().get();
        String branchName = "Not Latest";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        request.setLatest(false);
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(branchName).isNotLatest();
            BranchListResponse updatedProjectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
            ((AbstractListAssert)MeshAssertions.assertThat(updatedProjectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("New latest branches", new Object[0]).usingElementComparatorIgnoringFields(new String[]{"creator", "editor", "permissions", "rolePerms"})).containsOnly((Object[])new BranchResponse[]{latestBranch});
        }, JobStatus.COMPLETED, 1);
    }

    @Test
    public void testCreateMultipleNotAsLatest() {
        BranchListResponse projectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
        MeshAssertions.assertThat(projectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("Latest branches", new Object[0]).hasSize(1);
        BranchResponse latestBranch = projectBranches.getData().stream().filter(BranchResponse::getLatest).findFirst().get();
        for (String branchName : Arrays.asList("Branch 1", "Branch 2", "Branch 3")) {
            BranchCreateRequest request = new BranchCreateRequest();
            request.setName(branchName);
            request.setLatest(false);
            this.waitForJobs(() -> {
                BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
                ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(branchName).isNotLatest();
                BranchListResponse updatedProjectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
                ((AbstractListAssert)MeshAssertions.assertThat(updatedProjectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("New latest branches", new Object[0]).usingElementComparatorIgnoringFields(new String[]{"creator", "editor", "permissions", "rolePerms"})).containsOnly((Object[])new BranchResponse[]{latestBranch});
            }, JobStatus.COMPLETED, 1);
        }
    }

    @Test
    public void testCreateWithoutBaseBranch() {
        HibBranch latest = this.createBranch("Latest", true);
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("New Branch");
        HibBranch created = this.createBranch(request);
        this.tx(() -> ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)this.reloadBranch(created)).as("New Branch", new Object[0])).isNotNull()).hasPrevious(latest));
    }

    @Test
    public void testCreateWithBaseBranchByUuid() {
        this.createBranch("Latest", true);
        HibBranch base = this.createBranch("Base", false);
        String baseUuid = (String)this.tx(() -> base.getUuid());
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("New Branch");
        request.setBaseBranch((BranchReference)new BranchReference().setUuid(baseUuid));
        this.grantAdmin();
        HibBranch created = this.createBranch(request);
        this.tx(() -> ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)this.reloadBranch(created)).as("New Branch", new Object[0])).isNotNull()).hasPrevious(base));
    }

    @Test
    public void testCreateWithBaseBranchByName() {
        this.createBranch("Latest", true);
        HibBranch base = this.createBranch("Base", false);
        String baseName = (String)this.tx(() -> base.getName());
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("New Branch");
        request.setBaseBranch((BranchReference)new BranchReference().setName(baseName));
        this.grantAdmin();
        HibBranch created = this.createBranch(request);
        this.tx(() -> ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)this.reloadBranch(created)).as("New Branch", new Object[0])).isNotNull()).hasPrevious(base));
    }

    @Test
    public void testCreateWithNoPermBaseBranch() {
        HibBranch latest = this.createBranch("Latest", true);
        String latestUuid = (String)this.tx(() -> latest.getUuid());
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)latest, new InternalPermission[]{InternalPermission.READ_PERM});
        });
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("New Branch");
        request.setBaseBranch((BranchReference)new BranchReference().setUuid(latestUuid));
        ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{latestUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testCreateWithBogusBaseBranch() {
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("New Branch");
        request.setBaseBranch((BranchReference)new BranchReference().setUuid("bogus"));
        ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testCreateWithEmptyBaseBranchReference() {
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName("New Branch");
        request.setBaseBranch(new BranchReference());
        this.createBranch(request);
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        ArrayList<Pair> branchInfo = new ArrayList<Pair>();
        EventQueueBatch batch = this.createBatch();
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            branchInfo.add(Pair.of((Object)initialBranch.getUuid(), (Object)initialBranch.getName()));
            HibBranch firstBranch = branchDao.create(project, "One", this.user(), batch);
            branchInfo.add(Pair.of((Object)firstBranch.getUuid(), (Object)firstBranch.getName()));
            HibBranch secondBranch = branchDao.create(project, "Two", this.user(), batch);
            branchInfo.add(Pair.of((Object)secondBranch.getUuid(), (Object)secondBranch.getName()));
            HibBranch thirdBranch = branchDao.create(project, "Three", this.user(), batch);
            branchInfo.add(Pair.of((Object)thirdBranch.getUuid(), (Object)thirdBranch.getName()));
            tx.success();
        }
        for (Pair info : branchInfo) {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", (String)info.getKey(), new ParameterProvider[0]));
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).isNotNull()).hasName((String)info.getValue()).hasUuid((String)info.getKey()).isActive().hasPathPrefix("");
        }
    }

    @Override
    @Test
    public void testPermissionResponse() {
        BranchResponse branch = (BranchResponse)((BranchListResponse)this.client().findBranches("dummy", new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)branch.getPermissions()).hasNoPublishPermsSet();
    }

    @Test
    public void testReadByBogusUUID() throws Exception {
        ClientHelper.call(() -> this.client().findBranchByUuid("dummy", "bogus", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        String roleUuid = (String)this.db().tx(() -> this.role().getUuid());
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", this.initialBranchUuid(), new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(roleUuid)}));
        MeshAssertions.assertThat((PermissionInfo)response.getRolePerms()).hasPerm(new Permission[]{Permission.READ, Permission.CREATE, Permission.UPDATE, Permission.DELETE});
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        this.revokeAdmin();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project().getInitialBranch(), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findBranchByUuid("dummy", this.initialBranchUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.initialBranchUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testReadMultiple() throws Exception {
        HibBranch thirdBranch;
        HibBranch secondBranch;
        HibBranch firstBranch;
        HibBranch initialBranch;
        EventQueueBatch batch = this.createBatch();
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibProject project = this.project();
            initialBranch = project.getInitialBranch();
            firstBranch = branchDao.create(project, "One", this.user(), batch);
            secondBranch = branchDao.create(project, "Two", this.user(), batch);
            thirdBranch = branchDao.create(project, "Three", this.user(), batch);
            tx.success();
        }
        tx = this.tx();
        try {
            ListResponse responseList = (ListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
            InternalActionContext ac = this.mockActionContext();
            BranchDao branchDao = tx.branchDao();
            BranchResponse initial = (BranchResponse)branchDao.transformToRestSync((Object)this.reloadBranch(initialBranch), ac, 0, new String[0]);
            BranchResponse second = (BranchResponse)branchDao.transformToRestSync((Object)this.reloadBranch(secondBranch), ac, 0, new String[0]);
            BranchResponse first = (BranchResponse)branchDao.transformToRestSync((Object)this.reloadBranch(firstBranch), ac, 0, new String[0]);
            BranchResponse third = (BranchResponse)branchDao.transformToRestSync((Object)this.reloadBranch(thirdBranch), ac, 0, new String[0]);
            MeshAssertions.assertThat((Object)responseList).isNotNull();
            ((AbstractListAssert)MeshAssertions.assertThat((List)responseList.getData()).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new BranchResponse[]{initial, first, second, third});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[]{param})), BranchResponse::getName, "name", "List of branch names");
    }

    @Test
    public void testReadMultipleWithRestrictedPermissions() throws Exception {
        HibBranch thirdBranch;
        HibBranch secondBranch;
        HibBranch firstBranch;
        EventQueueBatch batch = this.createBatch();
        HibBranch initialBranch = (HibBranch)this.tx(() -> this.initialBranch());
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            firstBranch = branchDao.create(project, "One", this.user(), batch);
            secondBranch = branchDao.create(project, "Two", this.user(), batch);
            thirdBranch = branchDao.create(project, "Three", this.user(), batch);
            tx.success();
        }
        this.revokeAdmin();
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)firstBranch, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)thirdBranch, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        ListResponse responseList = (ListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            MeshAssertions.assertThat((Object)responseList).isNotNull();
            BranchDao branchDao = tx.branchDao();
            BranchResponse initial = (BranchResponse)branchDao.transformToRestSync((Object)this.reloadBranch(initialBranch), ac, 0, new String[0]);
            BranchResponse second = (BranchResponse)branchDao.transformToRestSync((Object)this.reloadBranch(secondBranch), ac, 0, new String[0]);
            ((AbstractListAssert)MeshAssertions.assertThat((List)responseList.getData()).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new BranchResponse[]{initial, second});
        }
    }

    @Override
    @Test
    public void testUpdate() throws Exception {
        String newName = "New Branch Name";
        String anotherNewName = "Another New Branch Name";
        this.expect(MeshEvent.BRANCH_UPDATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(newName)).hasUuid(this.initialBranchUuid()));
        BranchUpdateRequest request1 = new BranchUpdateRequest();
        request1.setName(newName);
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request1));
        ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated Branch", new Object[0])).isNotNull()).hasName(newName).isActive();
        this.awaitEvents();
        BranchUpdateRequest request2 = new BranchUpdateRequest();
        response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request2));
        ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated Branch", new Object[0])).isNotNull()).hasName(newName).isInactive();
        BranchUpdateRequest request3 = new BranchUpdateRequest();
        request3.setName(anotherNewName);
        response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request3));
        ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated Branch", new Object[0])).isNotNull()).hasName(anotherNewName).isActive();
    }

    @Test
    public void testUpdateWithNameConflict() throws Exception {
        EventQueueBatch batch = this.createBatch();
        String newName = "New Branch Name";
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            branchDao.create(this.project(), newName, this.user(), batch);
            tx.success();
        }
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setName(newName);
        ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"branch_conflicting_name", (String[])new String[]{newName});
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        this.revokeAdmin();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project().getInitialBranch(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        BranchUpdateRequest request = new BranchUpdateRequest();
        ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.initialBranchUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        BranchUpdateRequest request = new BranchUpdateRequest();
        ClientHelper.call(() -> this.client().updateBranch("dummy", "bogus", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testUpdateHostname() {
        String hostname = "new.hostname";
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setHostname(hostname);
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated branch", new Object[0])).hasHostname(hostname);
    }

    @Test
    public void testUpdateHostname2() {
        String hostname = "new.hostname";
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setHostname(hostname);
        request.setName("dummy");
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated branch", new Object[0])).hasHostname(hostname);
    }

    @Test
    public void testUpdatePathPrefix() {
        this.testPrefix("my/prefix");
        this.testPrefix("");
        this.testPrefix("test");
        this.testPrefix("/test");
    }

    private void testPrefix(String prefix) {
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setPathPrefix(prefix);
        request.setName("dummy");
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated branch", new Object[0])).hasPathPrefix(prefix);
        BranchResponse response1 = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", response.getUuid(), new ParameterProvider[0]));
        ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response1).as("Read updated branch", new Object[0])).hasPathPrefix(prefix);
        this.checkPathRendering("/api/v2/dummy/webroot", prefix, LinkType.FULL);
        this.checkPathRendering("", prefix, LinkType.SHORT);
    }

    private void checkPathRendering(String basePath, String prefix, LinkType type) {
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(type)}));
        Object segment = prefix;
        if (!prefix.isEmpty() && !prefix.startsWith("/")) {
            segment = "/" + prefix;
        }
        Assert.assertEquals((Object)(basePath + (String)segment + "/News/News%20Overview.en.html"), (Object)nodeResponse.getPath());
        Assert.assertEquals((Object)(basePath + (String)segment + "/Neuigkeiten/News%20Overview.de.html"), nodeResponse.getLanguagePaths().get("de"));
        Assert.assertEquals((Object)(basePath + (String)segment + "/News/News%20Overview.en.html"), nodeResponse.getLanguagePaths().get("en"));
    }

    @Test
    public void testUpdateSsl() {
        Boolean ssl = true;
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setSsl(ssl);
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Updated branch", new Object[0])).hasSsl(ssl);
    }

    @Test
    public void testSetLatest() {
        HashMap branchMap = new HashMap();
        for (String branchName : Arrays.asList("Branch 1", "Branch 2", "Branch 3")) {
            BranchCreateRequest request = new BranchCreateRequest();
            request.setName(branchName);
            request.setLatest(false);
            this.waitForJobs(() -> {
                BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
                ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(branchName).isNotLatest();
                branchMap.put(branchName, response.getUuid());
            }, JobStatus.COMPLETED, 1);
        }
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry entry : branchMap.entrySet()) {
                String branchName = (String)entry.getKey();
                String branchUuid = (String)entry.getValue();
                this.expect(MeshEvent.PROJECT_LATEST_BRANCH_UPDATED).match(1, ProjectBranchEventModel.class, event -> {
                    ProjectReference project = event.getProject();
                    Assert.assertEquals((String)"Project name not correct in event.", (Object)"dummy", (Object)project.getName());
                    Assert.assertEquals((String)"Project uuid not correct in event.", (Object)this.projectUuid(), (Object)project.getUuid());
                    Assert.assertEquals((String)"Branch name not correct in event.", (Object)branchName, (Object)event.getName());
                    Assert.assertEquals((String)"Branch uuid not correct in event.", (Object)branchUuid, (Object)event.getUuid());
                });
                BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().setLatestBranch("dummy", branchUuid));
                ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Latest branch", new Object[0])).hasUuid(branchUuid).hasName(branchName).isLatest();
                this.awaitEvents();
                BranchListResponse updatedProjectBranches = (BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]));
                ((AbstractListAssert)MeshAssertions.assertThat(updatedProjectBranches.getData().stream().filter(BranchResponse::getLatest).collect(Collectors.toList())).as("New latest branches", new Object[0]).usingElementComparatorIgnoringFields(new String[]{"creator", "editor", "permissions", "rolePerms"})).containsOnly((Object[])new BranchResponse[]{response});
            }
        }
    }

    @Test
    public void testSetLatestNoPerm() {
        this.revokeAdmin();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project().getInitialBranch(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().setLatestBranch("dummy", this.initialBranchUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.initialBranchUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadNoLatest() {
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", this.initialBranchUuid(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid", "name"})}));
        ((AbstractBooleanAssert)MeshAssertions.assertThat((Boolean)response.getLatest()).as("Latest flag", new Object[0])).isNull();
    }

    @Test
    public void testReadLatest() {
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", this.initialBranchUuid(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid", "name", "latest"})}));
        ((AbstractBooleanAssert)((AbstractBooleanAssert)MeshAssertions.assertThat((Boolean)response.getLatest()).as("Latest flag", new Object[0])).isNotNull()).isTrue();
    }

    @Override
    public void testDeleteByUUID() throws Exception {
    }

    @Override
    public void testDeleteByUUIDWithNoPermission() throws Exception {
    }

    @Test
    public void testReadSchemaVersions() throws Exception {
        try (Tx tx = this.tx();){
            BranchInfoSchemaList list = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
            BranchSchemaInfo content = new BranchSchemaInfo(((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).transformToReference());
            BranchSchemaInfo folder = new BranchSchemaInfo(((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).transformToReference());
            BranchSchemaInfo binaryContent = new BranchSchemaInfo(((HibSchemaVersion)this.schemaContainer("binary_content").getLatestVersion()).transformToReference());
            ((AbstractListAssert)MeshAssertions.assertThat((List)list.getSchemas()).as("branch schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).containsOnly((Object[])new BranchSchemaInfo[]{content, folder, binaryContent});
        }
    }

    @Test
    public void testAssignSchemaVersionViaSchemaUpdate() throws Exception {
        SchemaResponse schema = (SchemaResponse)this.tx(() -> this.createSchema("schemaname"));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
        this.waitForJobs(() -> this.updateSchema(schema.getUuid(), "newschemaname", new SchemaUpdateParameters[0]), JobStatus.COMPLETED, 1);
        BranchInfoSchemaList infoList = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)infoList.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("newschemaname").setUuid(schema.getUuid()).setVersion("2.0")});
        this.updateSchema(schema.getUuid(), "anothernewschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
        infoList = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)infoList.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("newschemaname").setUuid(schema.getUuid()).setVersion("2.0")});
        this.updateSchema(schema.getUuid(), "anothernewschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false).setBranchNames(new String[]{"dummy"}));
        infoList = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)infoList.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("newschemaname").setUuid(schema.getUuid()).setVersion("2.0")});
        this.waitForJobs(() -> this.updateSchema(schema.getUuid(), "anothernewschemaname2", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)), JobStatus.COMPLETED, 1);
        infoList = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)infoList.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("anothernewschemaname2").setUuid(schema.getUuid()).setVersion("4.0")});
        this.updateSchema(schema.getUuid(), "anothernewschemaname3", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true).setBranchNames(new String[]{"bla", "bogus", "moped"}));
        infoList = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)infoList.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("anothernewschemaname2").setUuid(schema.getUuid()).setVersion("4.0")});
    }

    @Test
    public void testAssignSchemaVersion() throws Exception {
        this.grantAdmin();
        SchemaResponse schema = this.createSchema("schemaname");
        this.expect(MeshEvent.SCHEMA_BRANCH_ASSIGN).one().match(1, BranchSchemaAssignEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            SchemaReference schemaRef = (SchemaReference)event.getSchema();
            Assert.assertEquals((Object)schema.getName(), (Object)schemaRef.getName());
            Assert.assertEquals((Object)schema.getUuid(), (Object)schemaRef.getUuid());
            Assert.assertEquals((Object)"1.0", (Object)schema.getVersion());
            ProjectReference projectRef = event.getProject();
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
        this.awaitEvents();
        this.expect(MeshEvent.SCHEMA_BRANCH_ASSIGN).none();
        this.updateSchema(schema.getUuid(), "newschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
        this.awaitEvents();
        this.expect(MeshEvent.SCHEMA_BRANCH_ASSIGN).none();
        this.updateSchema(schema.getUuid(), "anothernewschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
        this.awaitEvents();
        BranchInfoSchemaList list = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("schemaname").setUuid(schema.getUuid()).setVersion("1.0")});
        this.expect(MeshEvent.SCHEMA_BRANCH_ASSIGN).one().match(1, BranchSchemaAssignEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            SchemaReference schemaRef = (SchemaReference)event.getSchema();
            Assert.assertEquals((Object)"newschemaname", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schema.getUuid(), (Object)schemaRef.getUuid());
            Assert.assertEquals((Object)"2.0", (Object)schemaRef.getVersion());
            ProjectReference projectRef = event.getProject();
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        this.expect(MeshEvent.SCHEMA_MIGRATION_FINISHED).one();
        this.expect(MeshEvent.SCHEMA_MIGRATION_START).one();
        BranchInfoSchemaList info = new BranchInfoSchemaList();
        info.getSchemas().add(new BranchSchemaInfo().setUuid(schema.getUuid()).setVersion("2.0"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), info)), JobStatus.COMPLETED, 1);
        this.awaitEvents();
        JobListResponse jobList = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        JobResponse job = jobList.getData().stream().filter(j -> ((String)j.getProperties().get("schemaUuid")).equals(schema.getUuid())).findAny().get();
        BranchInfoSchemaList schemaList = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        BranchSchemaInfo schemaInfo = schemaList.getSchemas().stream().filter(s -> s.getUuid().equals(schema.getUuid())).findFirst().get();
        Assert.assertEquals((Object)JobStatus.COMPLETED, (Object)schemaInfo.getMigrationStatus());
        Assert.assertEquals((Object)job.getUuid(), (Object)schemaInfo.getJobUuid());
        list = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("newschemaname").setUuid(schema.getUuid()).setVersion("2.0")});
    }

    @Test
    public void testAssignBogusSchemaVersion() throws Exception {
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion("4711.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_schema_reference_not_found", (String[])new String[]{"content", "-", "4711.0"});
    }

    @Test
    public void testAssignBogusSchemaUuid() throws Exception {
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setUuid("bogusuuid")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_schema_reference_not_found", (String[])new String[]{"-", "bogusuuid", "1.0"});
    }

    @Test
    public void testAssignBogusSchemaName() throws Exception {
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("bogusname")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_schema_reference_not_found", (String[])new String[]{"bogusname", "-", "1.0"});
    }

    @Test
    public void testAssignUnassignedSchemaVersion() throws Exception {
        String schemaName = "schemaname";
        try (Tx tx = this.tx();){
            this.createSchema("schemaname");
            tx.success();
        }
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("schemaname")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_schema_reference_not_found", (String[])new String[]{"schemaname", "-", "1.0"});
    }

    @Test
    public void testAssignOlderSchemaVersion() throws Exception {
        String schemaUuid;
        try (Tx tx = this.tx();){
            SchemaResponse schema = this.createSchema("schemaname");
            schemaUuid = schema.getUuid();
            this.updateSchema(schema.getUuid(), "newschemaname", new SchemaUpdateParameters[0]);
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
            tx.success();
        }
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setUuid(schemaUuid)).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"branch_error_downgrade_schema_version", (String[])new String[]{"schemaname", "2.0", "1.0"});
    }

    @Test
    public void testAssignSchemaVersionNoPermission() throws Exception {
        this.revokeAdmin();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibProject project = this.project();
            roleDao.revokePermissions(this.role(), (HibBaseElement)project.getInitialBranch(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.initialBranchUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testAssignLatestSchemaVersion() throws Exception {
        String schemaUuid;
        try (Tx tx = this.tx();){
            SchemaResponse schema = this.createSchema("schemaname");
            schemaUuid = schema.getUuid();
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
            this.updateSchema(schema.getUuid(), "newschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
            this.updateSchema(schema.getUuid(), "anothernewschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
            tx.success();
        }
        BranchInfoSchemaList list = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("schemaname").setUuid(schemaUuid).setVersion("1.0")});
        BranchInfoSchemaList info = new BranchInfoSchemaList();
        info.getSchemas().add(new BranchSchemaInfo().setUuid(schemaUuid));
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), info));
        list = (BranchInfoSchemaList)ClientHelper.call(() -> this.client().getBranchSchemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getSchemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchSchemaInfo[]{new BranchSchemaInfo().setName("anothernewschemaname").setUuid(schemaUuid).setVersion("3.0")});
    }

    @Test
    public void testReadMicroschemaVersions() throws Exception {
        BranchMicroschemaInfo vcard = new BranchMicroschemaInfo((MicroschemaReference)this.db().tx(() -> this.microschemaContainer("vcard").getLatestVersion().transformToReference()));
        BranchMicroschemaInfo captionedImage = new BranchMicroschemaInfo((MicroschemaReference)this.db().tx(() -> this.microschemaContainer("captionedImage").getLatestVersion().transformToReference()));
        BranchInfoMicroschemaList list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("branch microschema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).containsOnly((Object[])new BranchMicroschemaInfo[]{vcard, captionedImage});
    }

    @Test
    public void testAssignMicroschemaVersion() throws Exception {
        MicroschemaResponse microschema = (MicroschemaResponse)this.tx(() -> this.createMicroschema("microschemaname"));
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("dummy", microschema.getUuid()));
        this.updateMicroschema(microschema.getUuid(), "newmicroschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
        this.updateMicroschema(microschema.getUuid(), "anothernewmicroschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
        BranchInfoMicroschemaList list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial microschema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("microschemaname")).setUuid(microschema.getUuid())).setVersion("1.0"))});
        BranchInfoMicroschemaList info = new BranchInfoMicroschemaList();
        info.add(new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setUuid(microschema.getUuid())).setVersion("2.0")});
        this.expect(MeshEvent.MICROSCHEMA_BRANCH_ASSIGN).match(1, BranchMicroschemaAssignModel.class, event -> {
            BranchReference branch = event.getBranch();
            Assert.assertNotNull((String)"The branch reference was missing in the assignment event.", (Object)branch);
            Assert.assertEquals((String)"Branch name did not match.", (Object)"dummy", (Object)branch.getName());
            Assert.assertEquals((String)"Branch uuid did not match.", (Object)this.initialBranchUuid(), (Object)branch.getUuid());
            MicroschemaReference schemaRef = (MicroschemaReference)event.getSchema();
            Assert.assertEquals((String)"Version did not match.", (Object)"2.0", (Object)schemaRef.getVersion());
            Assert.assertEquals((String)"Microschema name did not match.", (Object)"newmicroschemaname", (Object)schemaRef.getName());
            Assert.assertEquals((String)"Microschema uuid did not match.", (Object)microschema.getUuid(), (Object)schemaRef.getUuid());
        });
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), info)), JobStatus.COMPLETED, 1);
        this.awaitEvents();
        list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial microschema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("newmicroschemaname")).setUuid(microschema.getUuid())).setVersion("2.0"))});
    }

    @Test
    public void testAssignMicroschemaVersionViaMicroschemaUpdate() throws Exception {
        MicroschemaResponse microschema = (MicroschemaResponse)this.tx(() -> this.createMicroschema("microschemaname"));
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("dummy", microschema.getUuid()));
        this.waitForJobs(() -> this.updateMicroschema(microschema.getUuid(), "newmicroschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)), JobStatus.COMPLETED, 1);
        this.waitForJobs(() -> this.updateMicroschema(microschema.getUuid(), "anothernewmicroschemaname", new SchemaUpdateParameters[0]), JobStatus.COMPLETED, 1);
        BranchInfoMicroschemaList list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial microschema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("anothernewmicroschemaname")).setUuid(microschema.getUuid())).setVersion("3.0"))});
    }

    @Test
    public void testAssignBogusMicroschemaVersion() throws Exception {
        ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard")).setVersion("4711")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_microschema_reference_not_found", (String[])new String[]{"vcard", "-", "4711"});
    }

    @Test
    public void testAssignBogusMicroschemaUuid() throws Exception {
        ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setUuid("bogusuuid")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_microschema_reference_not_found", (String[])new String[]{"-", "bogusuuid", "1.0"});
    }

    @Test
    public void testAssignBogusMicroschemaName() throws Exception {
        ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName("bogusname")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_microschema_reference_not_found", (String[])new String[]{"bogusname", "-", "1.0"});
    }

    @Test
    public void testAssignUnassignedMicroschemaVersion() throws Exception {
        try (Tx tx = this.tx();){
            SchemaResponse schema = this.createSchema("microschemaname");
            ClientHelper.call(() -> this.lambda$testAssignUnassignedMicroschemaVersion$133((SchemaVersionModel)schema), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_microschema_reference_not_found", (String[])new String[]{schema.getName(), "-", schema.getVersion()});
        }
    }

    @Test
    public void testAssignOlderMicroschemaVersion() throws Exception {
        MicroschemaResponse microschema = this.createMicroschema("microschemaname");
        this.updateMicroschema(microschema.getUuid(), "newmicroschemaname", new SchemaUpdateParameters[0]);
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("dummy", microschema.getUuid()));
        ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setUuid(microschema.getUuid())).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"branch_error_downgrade_microschema_version", (String[])new String[]{"microschemaname", "2.0", "1.0"});
    }

    @Test
    public void testAssignMicroschemaVersionNoPermission() throws Exception {
        this.revokeAdmin();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibProject project = this.project();
            roleDao.revokePermissions(this.role(), (HibBaseElement)project.getInitialBranch(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard")).setVersion("1.0")}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.initialBranchUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testMigrateBranchSchemas() {
        ClientHelper.call(() -> this.client().migrateBranchSchemas("dummy", this.initialBranchUuid()));
    }

    @Test
    public void testBranchMicroschemas() {
        ClientHelper.call(() -> this.client().migrateBranchMicroschemas("dummy", this.initialBranchUuid()));
    }

    @Test
    public void testAssignLatestMicroschemaVersion() throws Exception {
        MicroschemaResponse microschema = (MicroschemaResponse)this.tx(() -> this.createMicroschema("microschemaname"));
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("dummy", microschema.getUuid()));
        this.waitForJobs(() -> this.updateMicroschema(microschema.getUuid(), "newmicroschemaname", new SchemaUpdateParameters[0]), JobStatus.COMPLETED, 1);
        BranchInfoMicroschemaList list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial microschema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("newmicroschemaname")).setUuid(microschema.getUuid())).setVersion("2.0"))});
        this.updateMicroschema(microschema.getUuid(), "anothernewschemaname", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false));
        list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("newmicroschemaname")).setUuid(microschema.getUuid())).setVersion("2.0"))});
        this.updateMicroschema(microschema.getUuid(), "anothernewschemaname1", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true).setBranchNames(new String[]{"dummy"}));
        list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("anothernewschemaname1")).setUuid(microschema.getUuid())).setVersion("4.0"))});
        this.waitForJobs(() -> this.updateMicroschema(microschema.getUuid(), "anothernewschemaname2", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true)), JobStatus.COMPLETED, 1);
        list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("anothernewschemaname2")).setUuid(microschema.getUuid())).setVersion("5.0"))});
        this.updateMicroschema(microschema.getUuid(), "anothernewschemaname3", new SchemaUpdateParametersImpl().setUpdateAssignedBranches(true).setBranchNames(new String[]{"bla", "bogus", "moped"}));
        list = (BranchInfoMicroschemaList)ClientHelper.call(() -> this.client().getBranchMicroschemaVersions("dummy", this.initialBranchUuid()));
        ((AbstractListAssert)MeshAssertions.assertThat((List)list.getMicroschemas()).as("Initial schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"name", "uuid", "version"})).contains((Object[])new BranchMicroschemaInfo[]{new BranchMicroschemaInfo(((MicroschemaReference)((MicroschemaReference)new MicroschemaReferenceImpl().setName("anothernewschemaname2")).setUuid(microschema.getUuid())).setVersion("5.0"))});
    }

    @Test
    public void testNodeMigrationToNewBranch() {
        NodeResponse node = this.createNode("name", (Field)new StringFieldImpl().setString("name"));
        this.addSchemaField();
        this.waitForJobs(() -> {
            BranchCreateRequest request = new BranchCreateRequest();
            request.setName("branch1");
            ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 2);
        NodeResponse originalNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch("dummy")}));
        NodeResponse migratedNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)originalNode).hasSchemaVersion("folder", "1.0");
        MeshAssertions.assertThat((NodeResponse)migratedNode).hasSchemaVersion("folder", "2.0");
        MeshAssertions.assertThat((NodeResponse)originalNode).hasVersion("0.1");
        MeshAssertions.assertThat((NodeResponse)migratedNode).hasVersion("0.2");
    }

    private void addSchemaField() {
        SchemaResponse folder = this.getSchemaByName("folder");
        SchemaUpdateRequest request = folder.toUpdateRequest();
        request.getFields().add(new StringFieldSchemaImpl().setName("testField"));
        ClientHelper.call(() -> this.client().updateSchema(folder.getUuid(), request, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
    }

    @Test
    public void testUnassignedMigration() {
        this.updateFolderSchema(false);
        this.migrateSchema();
    }

    private void updateFolderSchema(boolean immediate) {
        ParameterProvider[] parameterProviderArray;
        SchemaResponse schema = this.getSchemaByName("folder");
        SchemaUpdateRequest request = new SchemaUpdateRequest();
        request.setName(schema.getName());
        request.getFields().addAll(schema.getFields());
        request.getFields().add(new StringFieldSchemaImpl().setName("testField"));
        request.setContainer(Boolean.valueOf(true));
        if (immediate) {
            parameterProviderArray = new ParameterProvider[]{};
        } else {
            ParameterProvider[] parameterProviderArray2 = new ParameterProvider[1];
            parameterProviderArray = parameterProviderArray2;
            parameterProviderArray2[0] = new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false);
        }
        ParameterProvider[] parameters = parameterProviderArray;
        this.client().updateSchema(schema.getUuid(), request, parameters).toSingle().blockingGet();
    }

    private void migrateSchema() {
        this.client().migrateBranchSchemas("dummy", this.getCurrentBranch().getUuid()).toSingle().blockingGet();
    }

    private BranchResponse getCurrentBranch() {
        return (BranchResponse)((Observable)this.client().findBranches("dummy", new ParameterProvider[0]).toSingle().to(TestUtils::listObservable)).blockingFirst();
    }

    private /* synthetic */ MeshRequest lambda$testAssignUnassignedMicroschemaVersion$133(SchemaVersionModel schema) throws Exception {
        return this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName(schema.getName())).setVersion(schema.getVersion())});
    }
}

