/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.branch;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BranchMigrationEndpointTest
extends AbstractMeshTest {
    @Before
    public void setupVerticleTest() throws Exception {
        DeploymentOptions options = new DeploymentOptions();
        options.setWorker(true);
        this.vertx().deployVerticle((Verticle)this.meshDagger().jobWorkerVerticle(), options);
        this.grantAdmin();
    }

    @Test
    public void testStartBranchMigration() throws Throwable {
        HibBranch newBranch;
        List<HibNode> nodes;
        NodeDao nodeDao;
        EventQueueBatch batch = this.createBatch();
        HibProject project = this.project();
        try (Tx tx = this.tx();){
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)project.getInitialBranch().isMigrated()).as("Initial branch migration status", new Object[0])).isEqualTo(true);
        }
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", (String)this.tx(() -> this.project().getBaseNode().getUuid()), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        List<HibNode> published = Arrays.asList(this.folder("news"), this.folder("2015"), this.folder("2014"), this.folder("march"));
        tx = this.tx();
        try {
            nodeDao = tx.nodeDao();
            nodes = nodeDao.findAll((HibCoreElement)project).stream().filter(node -> nodeDao.getParentNode(node, project.getLatestBranch().getUuid()) != null).collect(Collectors.toList());
            Assertions.assertThat(nodes).as("Nodes list", new Object[0]).isNotEmpty();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        published.forEach(node -> ClientHelper.call(() -> this.client().publishNode("dummy", (String)this.tx(() -> node.getUuid()), new ParameterProvider[0])));
        tx = this.tx();
        try {
            newBranch = tx.branchDao().create(project, "newbranch", this.user(), batch);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)newBranch.isMigrated()).as("Branch migration status", new Object[0])).isEqualTo(false);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        nodes.forEach(node -> Arrays.asList(ContainerType.INITIAL, ContainerType.DRAFT, ContainerType.PUBLISHED).forEach(type -> Assertions.assertThat((List)((List)this.tx(() -> Tx.get().contentDao().getFieldContainers(node, newBranch, type).list()))).as(type + " Field Containers before Migration", new Object[0]).isNotNull().isEmpty()));
        this.triggerAndWaitForJob(this.requestBranchMigration(newBranch));
        tx = this.tx();
        try {
            nodeDao = tx.nodeDao();
            HibBranch newBranchReloaded = this.reloadBranch(newBranch);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)newBranchReloaded.isMigrated()).as("Branch migration status", new Object[0])).isEqualTo(true);
            nodes.forEach(node -> {
                Arrays.asList(ContainerType.INITIAL, ContainerType.DRAFT).forEach(type -> Assertions.assertThat((Iterable)tx.contentDao().getFieldContainers(node, newBranchReloaded, type)).as(type + " Field Containers after Migration", new Object[0]).isNotNull().isNotEmpty());
                if (published.contains(node)) {
                    Assertions.assertThat((Iterable)tx.contentDao().getFieldContainers(node, newBranchReloaded, ContainerType.PUBLISHED)).as("Published field containers after migration", new Object[0]).isNotNull().isNotEmpty();
                } else {
                    Assertions.assertThat((Iterable)tx.contentDao().getFieldContainers(node, newBranchReloaded, ContainerType.PUBLISHED)).as("Published field containers after migration", new Object[0]).isNotNull().isEmpty();
                }
                HibNode initialParent = nodeDao.getParentNode(node, this.initialBranchUuid());
                if (initialParent == null) {
                    ((AbstractObjectAssert)Assertions.assertThat((Object)nodeDao.getParentNode(node, newBranchReloaded.getUuid())).as("Parent in new branch", new Object[0])).isNull();
                } else {
                    ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)nodeDao.getParentNode(node, newBranchReloaded.getUuid())).as("Parent in new branch", new Object[0])).isNotNull()).isEqualToComparingOnlyGivenFields((Object)initialParent, new String[]{"uuid"});
                }
            });
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testStartForInitial() throws Throwable {
        this.triggerAndWaitForJob((String)this.tx(() -> this.requestBranchMigration(this.initialBranch())), JobStatus.FAILED);
    }

    @Test
    public void testStartAgain() throws Throwable {
        EventQueueBatch batch = this.createBatch();
        HibBranch newBranch = (HibBranch)this.tx(tx -> tx.branchDao().create(this.project(), "newbranch", this.user(), batch));
        String jobUuidA = this.requestBranchMigration(newBranch);
        this.triggerAndWaitForJob(jobUuidA, JobStatus.COMPLETED);
        String jobUuidB = this.requestBranchMigration(newBranch);
        JobListResponse response = this.triggerAndWaitForJob(jobUuidB, JobStatus.FAILED);
        List status = response.getData().stream().map(e -> e.getStatus()).collect(Collectors.toList());
        Assertions.assertThat(status).contains((Object[])new JobStatus[]{JobStatus.COMPLETED, JobStatus.FAILED});
    }

    @Test
    public void testStartOrder() throws Throwable {
        HibProject project = this.project();
        EventQueueBatch batch = this.createBatch();
        String newBranch = (String)this.tx(tx -> tx.branchDao().create(project, "newbranch", this.user(), batch).getUuid());
        String newestBranch = (String)this.tx(tx -> tx.branchDao().create(project, "newestbranch", this.user(), batch).getUuid());
        this.triggerAndWaitForJob((String)this.tx(tx -> this.requestBranchMigration((HibBranch)tx.branchDao().findByUuid((HibCoreElement)this.project(), newestBranch))), JobStatus.FAILED);
        JobListResponse response = this.triggerAndWaitForJob((String)this.tx(tx -> this.requestBranchMigration((HibBranch)tx.branchDao().findByUuid((HibCoreElement)this.project(), newBranch))), JobStatus.COMPLETED);
        List status = response.getData().stream().map(e -> e.getStatus()).collect(Collectors.toList());
        Assertions.assertThat(status).contains((Object[])new JobStatus[]{JobStatus.FAILED, JobStatus.COMPLETED});
        response = this.triggerAndWaitForJob((String)this.tx(tx -> this.requestBranchMigration((HibBranch)tx.branchDao().findByUuid((HibCoreElement)this.project(), newestBranch))), JobStatus.COMPLETED);
        status = response.getData().stream().map(e -> e.getStatus()).collect(Collectors.toList());
        Assertions.assertThat(status).contains((Object[])new JobStatus[]{JobStatus.FAILED, JobStatus.COMPLETED, JobStatus.COMPLETED});
    }

    @Test
    public void testMigrateNodesWithoutSegment() {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("dummyData");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"test"));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        String schemaUuid = response.getUuid();
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaUuid));
        for (int i = 0; i < 2; ++i) {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setSchemaName("dummyData");
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.setParentNodeUuid(baseNodeUuid);
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0]));
        }
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().createBranch("dummy", new BranchCreateRequest().setName("branch1"), new ParameterProvider[0])), JobStatus.COMPLETED, 1);
    }

    @Test
    public void testBigData() throws Throwable {
        HibBranch newBranch;
        EventQueueBatch batch = this.createBatch();
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        this.createNode(baseNodeUuid);
        try (Tx tx = this.tx();){
            int numThreads = 1;
            int numFolders = 1000;
            ExecutorService service = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
            for (int i = 0; i < numFolders; ++i) {
                futures.add(service.submit(() -> {
                    this.createNode(baseNodeUuid);
                    return true;
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            newBranch = tx.branchDao().create(this.project(), "newbranch", this.user(), batch);
            tx.success();
        }
        String jobUuid = this.requestBranchMigration(newBranch);
        this.triggerAndWaitForJob(jobUuid);
    }

    private void createNode(String baseNodeUuid) {
        NodeCreateRequest create = new NodeCreateRequest();
        create.setLanguage("en");
        create.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        create.setParentNodeUuid(baseNodeUuid);
        ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
    }

    protected String requestBranchMigration(HibBranch branch) {
        return (String)this.tx(tx -> tx.jobDao().enqueueBranchMigration(this.user(), branch).getUuid());
    }
}

