/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.branch;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.event.branch.BranchTaggedEventModel;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.core.rest.tag.TagListUpdateRequest;
import com.gentics.mesh.core.rest.tag.TagReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.GenericParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BranchTagEndpointTest
extends AbstractMeshTest {
    @Test
    public void testAddTagToBranch() throws Exception {
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        try (Tx tx = this.tx();){
            HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertFalse((boolean)branch.getTags().list().contains(tag));
        }
        this.expect(MeshEvent.BRANCH_TAGGED).match(1, BranchTaggedEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            TagReference tagRef = event.getTag();
            Assert.assertNotNull((Object)tagRef);
            Assert.assertEquals((String)"The tag name in the event did not match.", (Object)"red", (Object)tagRef.getName());
            Assert.assertEquals((String)"The tag uuid in the event did not match.", (Object)tagUuid, (Object)tagRef.getUuid());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        BranchResponse branchResponse = (BranchResponse)ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid));
        this.awaitEvents();
        try (Tx tx = this.tx();){
            HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((BranchResponse)branchResponse).contains(tag);
            Assert.assertTrue((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
        }
    }

    @Test
    public void testAddTagToNoPermBranch() throws Exception {
        HibBranch branch;
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        try (Tx tx = this.tx();){
            branch = this.project().getLatestBranch();
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((boolean)branch.getTags().list().contains(tag));
            roleDao.revokePermissions(this.role(), (HibBaseElement)branch, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{branchUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            branch = this.project().getLatestBranch();
            Assert.assertFalse((boolean)branch.getTags().list().contains(tag));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddNoPermTagToBranch() throws Exception {
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibBranch branch = this.project().getLatestBranch();
            Assert.assertFalse((boolean)branch.getTags().list().contains(tag));
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tagUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            HibBranch branch = this.project().getLatestBranch();
            Assert.assertFalse((boolean)branch.getTags().list().contains(tag));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddBogusTagToBranch() throws Exception {
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, "bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testAddTagToBogusBranch() throws Exception {
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", "bogus", tagUuid), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testRemoveTagFromBranch() throws Exception {
        HibBranch branch;
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid));
        try (Tx tx = this.tx();){
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertTrue((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
        }
        this.expect(MeshEvent.BRANCH_UNTAGGED).match(1, BranchTaggedEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            TagReference tagRef = event.getTag();
            Assert.assertNotNull((Object)tagRef);
            Assert.assertEquals((String)"The tag name in the event did not match.", (Object)"red", (Object)tagRef.getName());
            Assert.assertEquals((String)"The tag uuid in the event did not match.", (Object)tagUuid, (Object)tagRef.getUuid());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        ClientHelper.call(() -> this.client().removeTagFromBranch("dummy", branchUuid, tagUuid));
        ClientHelper.call(() -> this.client().removeTagFromBranch("dummy", branchUuid, tagUuid));
        this.awaitEvents();
        tx = this.tx();
        try {
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertFalse((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveTagFromNoPermBranch() throws Exception {
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertTrue((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
            roleDao.revokePermissions(this.role(), (HibBaseElement)branch, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{branchUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertTrue((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveNoPermTagFromBranch() throws Exception {
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertTrue((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tagUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tagUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            Assert.assertTrue((boolean)branch.getTags().stream().anyMatch(bt -> bt.getId().equals(tag.getId())));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveBogusTagFromBranch() throws Exception {
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        ClientHelper.call(() -> this.client().removeTagFromBranch("dummy", branchUuid, "bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testRemoveTagFromBogusBranch() throws Exception {
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        ClientHelper.call(() -> this.client().removeTagFromBranch("dummy", "bogus", tagUuid), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testReadTagsFromBranch() throws Exception {
        HibTag red = this.tag("red");
        String redUuid = (String)this.tx(() -> red.getUuid());
        HibTag blue = this.tag("blue");
        String blueUuid = (String)this.tx(() -> blue.getUuid());
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, redUuid));
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, blueUuid));
        TagListResponse tagListResponse = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForBranch("dummy", branchUuid, new ParameterProvider[0]));
        MeshAssertions.assertThat((TagListResponse)tagListResponse).containsExactly(new String[]{"red", "blue"});
    }

    @Test
    public void testReadNoPermTagsFromBranch() throws Exception {
        HibTag red = this.tag("red");
        String redUuid = (String)this.tx(() -> red.getUuid());
        HibTag blue = this.tag("blue");
        String blueUuid = (String)this.tx(() -> blue.getUuid());
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, redUuid));
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, blueUuid));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)red, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        TagListResponse tagListResponse = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForBranch("dummy", branchUuid, new ParameterProvider[0]));
        MeshAssertions.assertThat((TagListResponse)tagListResponse).containsExactly(new String[]{"blue"});
    }

    @Test
    public void testReadTagsFromNoPermBranch() throws Exception {
        HibTag red = this.tag("red");
        String redUuid = (String)this.tx(() -> red.getUuid());
        HibTag blue = this.tag("blue");
        String blueUuid = (String)this.tx(() -> blue.getUuid());
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, redUuid));
        ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, blueUuid));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)branch, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findTagsForBranch("dummy", branchUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{branchUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadTagsFromBogusBranch() throws Exception {
        ClientHelper.call(() -> this.client().findTagsForBranch("dummy", "bogus", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testReadNoTags() throws Exception {
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", branchUuid, new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid", "name"})}));
        MeshAssertions.assertThat((List)response.getTags()).as("Tags", new Object[0]).isNull();
    }

    @Test
    public void testReadWithTags() throws Exception {
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().findBranchByUuid("dummy", branchUuid, new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid", "name", "tags"})}));
        MeshAssertions.assertThat((List)response.getTags()).as("Tags", new Object[0]).isNotNull();
    }

    @Test
    public void testUpdateTagsForBranch() throws Exception {
        HibBranch branch;
        HibTag red = this.tag("red");
        HibTag blue = this.tag("blue");
        HibTag car = this.tag("car");
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        TagListResponse tagListResponse = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(red), this.ref(car)))));
        MeshAssertions.assertThat((TagListResponse)tagListResponse).containsExactly(new String[]{"red", "Car"});
        try (Tx tx = this.tx();){
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((HibBranch)branch).isOnlyTagged(new String[]{"red", "Car"});
        }
        tagListResponse = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(blue), this.ref(car)))));
        MeshAssertions.assertThat((TagListResponse)tagListResponse).containsExactly(new String[]{"blue", "Car"});
        tx = this.tx();
        try {
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((HibBranch)branch).isOnlyTagged(new String[]{"blue", "Car"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testUpdateNoPermTagsForBranch() throws Exception {
        HibBranch branch;
        HibTag red = this.tag("red");
        HibTag blue = this.tag("blue");
        String blueUuid = (String)this.tx(() -> blue.getUuid());
        HibTag car = this.tag("car");
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)blue, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        TagListResponse tagListResponse = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(red), this.ref(car)))));
        MeshAssertions.assertThat((TagListResponse)tagListResponse).containsExactly(new String[]{"red", "Car"});
        try (Tx tx = this.tx();){
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((HibBranch)branch).isOnlyTagged(new String[]{"red", "Car"});
        }
        ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(blue), this.ref(car)))), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{blueUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((HibBranch)branch).isOnlyTagged(new String[]{"red", "Car"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testUpdateTagsForNoPermBranch() throws Exception {
        HibBranch branch;
        HibTag red = this.tag("red");
        HibTag blue = this.tag("blue");
        HibTag car = this.tag("car");
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        TagListResponse tagListResponse = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(red), this.ref(car)))));
        MeshAssertions.assertThat((TagListResponse)tagListResponse).containsExactly(new String[]{"red", "Car"});
        try (Tx tx = this.tx();){
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((HibBranch)branch).isOnlyTagged(new String[]{"red", "Car"});
        }
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            HibBranch branch2 = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            roleDao.revokePermissions(this.role(), (HibBaseElement)branch2, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(blue), this.ref(car)))), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{branchUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
            MeshAssertions.assertThat((HibBranch)branch).isOnlyTagged(new String[]{"red", "Car"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testUpdateTagsForBogusBranch() throws Exception {
        HibTag red = this.tag("red");
        HibTag car = this.tag("car");
        ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", "bogus", new TagListUpdateRequest().setTags(Arrays.asList(this.ref(red), this.ref(car)))), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testUpdateBogusTagsForBranch() throws Exception {
        HibTag red = this.tag("red");
        HibBranch branch = (HibBranch)this.tx(() -> this.project().getLatestBranch());
        String branchUuid = (String)this.tx(() -> branch.getUuid());
        ClientHelper.call(() -> this.client().updateTagsForBranch("dummy", branchUuid, new TagListUpdateRequest().setTags(Arrays.asList(this.ref(red), this.ref("bogus", "colors")))), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"tag_not_found", (String[])new String[]{"bogus"});
    }

    protected TagReference ref(HibTag tag) {
        return (TagReference)this.tx(() -> this.ref(tag.getUuid(), tag.getTagFamily().getName()));
    }

    protected TagReference ref(String uuid, String tagFamilyName) {
        return ((TagReference)new TagReference().setUuid(uuid)).setTagFamily(tagFamilyName);
    }
}

