/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.branch;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.BranchAssert;
import com.gentics.mesh.assertj.impl.BranchResponseAssert;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibNamedElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.branch.HibBranchSchemaVersion;
import com.gentics.mesh.core.data.dao.BranchDao;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.dao.PersistingBranchDao;
import com.gentics.mesh.core.data.dao.PersistingSchemaDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.schema.handler.MicroschemaComparatorImpl;
import com.gentics.mesh.core.data.schema.handler.SchemaComparatorImpl;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class BranchTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibBranch branch = this.project().getInitialBranch();
            BranchReference reference = (BranchReference)branch.transformToReference();
            MeshAssertions.assertThat((Object)reference).isNotNull();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)reference.getName()).as("Reference name", new Object[0])).isEqualTo((Object)branch.getName());
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)reference.getUuid()).as("Reference uuid", new Object[0])).isEqualTo((Object)branch.getUuid());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws Exception {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            EventQueueBatch batch = this.createBatch();
            HibBranch initialBranch = (HibBranch)((CommonTx)tx.unwrap()).load(this.project().getInitialBranch().getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)this.project()));
            HibBranch branchOne = branchDao.create(this.project(), "One", this.user(), batch);
            HibBranch branchTwo = branchDao.create(this.project(), "Two", this.user(), batch);
            HibBranch branchThree = branchDao.create(this.project(), "Three", this.user(), batch);
            List branchNames = branchDao.findAll((HibCoreElement)this.project(), this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(25L))).getWrappedList().stream().map(HibNamedElement::getName).collect(Collectors.toList());
            MeshAssertions.assertThat(branchNames).isNotNull();
            MeshAssertions.assertThat(branchNames).contains((Object[])new String[]{initialBranch.getName(), branchOne.getName(), branchTwo.getName(), branchThree.getName()});
        }
    }

    @Override
    @Test
    public void testFindAll() throws Exception {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibProject project = this.project();
            HibBranch initialBranch = this.initialBranch();
            HibBranch branchOne = this.createBranch("One");
            HibBranch branchTwo = this.createBranch("Two");
            HibBranch branchThree = this.createBranch("Three");
            List branchList = branchDao.findAll((HibCoreElement)project).list();
            ((AbstractListAssert)MeshAssertions.assertThat(new ArrayList(branchList)).usingElementComparatorOnFields(new String[]{"uuid"})).containsExactlyInAnyOrder((Object[])new HibBranch[]{initialBranch, branchOne, branchTwo, branchThree});
        }
    }

    @Override
    @Test
    public void testRootNode() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            HibBaseElement branchRoot = project.getBranchPermissionRoot();
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)branchRoot).as("Branch Root of Project", new Object[0])).isNotNull();
            HibBranch initialBranch = project.getInitialBranch();
            ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)initialBranch).as("Initial Branch of Project", new Object[0])).isNotNull()).isActive().isNamed(project.getName()).hasUuid().hasNext(null).hasPrevious(null);
            HibBranch latestBranch = project.getLatestBranch();
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)latestBranch).as("Latest Branch of Project", new Object[0])).matches(initialBranch);
        }
    }

    @Override
    @Test
    public void testFindByName() throws Exception {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibProject project = this.project();
            HibBranch foundBranch = (HibBranch)branchDao.findByName((HibCoreElement)project, project.getName());
            ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)foundBranch).as("Branch with name " + project.getName(), new Object[0])).isNotNull()).matches(project.getInitialBranch());
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibBranch foundBranch = (HibBranch)branchDao.findByUuid((HibCoreElement)project, initialBranch.getUuid());
            ((BranchAssert)((BranchAssert)MeshAssertions.assertThat((HibBranch)foundBranch).as("Branch with uuid " + initialBranch.getUuid(), new Object[0])).isNotNull()).matches(initialBranch);
        }
    }

    @Override
    @Test
    public void testRead() throws Exception {
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            SchemaDao schemaDao = tx.schemaDao();
            HibBranch initialBranch = this.initialBranch();
            HibBranch firstNewBranch = this.createBranch("First new Branch");
            HibBranch secondNewBranch = this.createBranch("Second new Branch");
            HibBranch thirdNewBranch = this.createBranch("Third new Branch");
            HibProject project = this.project();
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)project.getInitialBranch()).as("Initial Branch", new Object[0])).matches(initialBranch).hasNext(firstNewBranch).hasPrevious(null);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)firstNewBranch).as("First new Branch", new Object[0])).isNamed("First new Branch").hasNext(secondNewBranch).hasPrevious(initialBranch);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)secondNewBranch).as("Second new Branch", new Object[0])).isNamed("Second new Branch").hasNext(thirdNewBranch).hasPrevious(firstNewBranch);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)project.getLatestBranch()).as("Latest Branch", new Object[0])).isNamed("Third new Branch").matches(thirdNewBranch).hasNext(null).hasPrevious(secondNewBranch);
            ((AbstractListAssert)MeshAssertions.assertThat(new ArrayList(branchDao.findAll((HibCoreElement)project).list())).usingElementComparatorOnFields(new String[]{"uuid"})).containsExactlyInAnyOrder((Object[])new HibBranch[]{initialBranch, firstNewBranch, secondNewBranch, thirdNewBranch});
            for (HibSchema schema : schemaDao.findAll((HibCoreElement)project)) {
                for (HibBranch branch : Arrays.asList(initialBranch, firstNewBranch, secondNewBranch, thirdNewBranch)) {
                    ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasSchema(schema).hasSchemaVersion((HibSchemaVersion)schema.getLatestVersion());
                }
            }
        }
    }

    @Override
    public void testDelete() throws Exception {
    }

    @Override
    @Test
    public void testUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            initialBranch.setName("New Branch Name");
            initialBranch.setActive(false);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)initialBranch).as("Branch", new Object[0])).isNamed("New Branch Name").isInactive();
        }
    }

    @Override
    @Test
    public void testReadPermission() throws Exception {
        try (Tx tx = this.tx();){
            HibBranch newBranch = this.createBranch("New Branch");
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)newBranch);
        }
    }

    @Override
    @Test
    public void testDeletePermission() throws Exception {
        try (Tx tx = this.tx();){
            HibBranch newBranch = this.createBranch("New Branch");
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)newBranch);
        }
    }

    @Override
    @Test
    public void testUpdatePermission() throws Exception {
        try (Tx tx = this.tx();){
            HibBranch newBranch = this.createBranch("New Branch");
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)newBranch);
        }
    }

    @Override
    @Test
    public void testCreatePermission() throws Exception {
        try (Tx tx = this.tx();){
            HibBranch newBranch = this.createBranch("New Branch");
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)newBranch);
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            BranchDao branchDao = tx.branchDao();
            HibBranch branch = this.project().getInitialBranch();
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            BranchResponse branchResponse = (BranchResponse)branchDao.transformToRestSync((Object)branch, (InternalActionContext)ac, 0, new String[0]);
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)branchResponse).isNotNull()).hasName(branch.getName()).hasUuid(branch.getUuid()).isActive().isMigrated();
        }
    }

    @Override
    public void testCreateDelete() throws Exception {
    }

    @Override
    public void testCRUDPermissions() throws Exception {
    }

    @Test
    public void testReadSchemaVersions() throws Exception {
        try (Tx tx = this.tx();){
            PersistingSchemaDao schemaDao = ((CommonTx)tx.unwrap()).schemaDao();
            PersistingBranchDao branchDao = ((CommonTx)tx.unwrap()).branchDao();
            HibProject project = this.project();
            HibBranch branch = this.latestBranch();
            List versions = schemaDao.findAll((HibCoreElement)project).stream().filter(v -> !v.getName().equals("content")).map(HibFieldSchemaElement::getLatestVersion).collect(Collectors.toList());
            HibSchema schema = this.schemaContainer("content");
            HibSchemaVersion newVersion = (HibSchemaVersion)schemaDao.createPersistedVersion((HibFieldSchemaElement)schema, v -> {
                v.setVersion("4.0");
                v.setName("content");
                v.setSchemaContainer(schema);
            });
            versions.add(newVersion);
            branchDao.connectToSchemaVersion(branch, newVersion);
            ArrayList<HibSchemaVersion> found = new ArrayList<HibSchemaVersion>();
            for (HibBranchSchemaVersion versionedge : branch.findAllLatestSchemaVersionEdges()) {
                found.add(versionedge.getSchemaContainerVersion());
            }
            ((AbstractListAssert)MeshAssertions.assertThat(found).as("List of schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name", "version"})).containsOnlyElementsOf(versions);
        }
    }

    @Test
    public void testAssignSchema() throws Exception {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibSchema schemaContainer = this.createSchemaDirect("bla");
            this.updateSchema(schemaContainer, "newfield");
            HibSchemaVersion latestVersion = (HibSchemaVersion)schemaContainer.getLatestVersion();
            ((AbstractComparableAssert)MeshAssertions.assertThat((Comparable)latestVersion).as("latest version", new Object[0])).isNotNull();
            HibSchemaVersion previousVersion = (HibSchemaVersion)latestVersion.getPreviousVersion();
            ((AbstractComparableAssert)MeshAssertions.assertThat((Comparable)previousVersion).as("Previous version", new Object[0])).isNotNull();
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibBranch newBranch = this.createBranch("New Branch");
            for (HibBranch branch : Arrays.asList(initialBranch, newBranch)) {
                branch = (HibBranch)((CommonTx)tx.unwrap()).load(branch.getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)project));
                ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasNotSchema(schemaContainer).hasNotSchemaVersion(latestVersion).hasNotSchemaVersion(previousVersion);
            }
            EventQueueBatch batch = this.createBatch();
            schemaDao.assign((HibFieldSchemaElement)schemaContainer, this.project(), this.user(), batch);
            for (HibBranch branch : Arrays.asList(initialBranch, newBranch)) {
                branch = (HibBranch)((CommonTx)tx.unwrap()).load(branch.getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)project));
                ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasSchema(schemaContainer).hasSchemaVersion(latestVersion).hasNotSchemaVersion(previousVersion);
            }
        }
    }

    @Test
    public void testUnassignSchema() throws Exception {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibProject project = this.project();
            List schemas = schemaDao.findAll((HibCoreElement)project).list();
            HibSchema schemaContainer = (HibSchema)schemas.get(0);
            HibBranch initialBranch = this.initialBranch();
            HibBranch newBranch = this.createBranch("New Branch");
            EventQueueBatch batch = this.createBatch();
            schemaDao.unassign((HibFieldSchemaElement)schemaContainer, project, batch);
            for (HibBranch branch : Arrays.asList(initialBranch, newBranch)) {
                branch = (HibBranch)((CommonTx)tx.unwrap()).load(branch.getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)project));
                ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasNotSchema(schemaContainer).hasNotSchemaVersion((HibSchemaVersion)schemaContainer.getLatestVersion());
            }
        }
    }

    @Test
    public void testFindActiveSchemaVersions() {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibProject project = this.project();
            HibBranch branch = this.latestBranch();
            List versions = schemaDao.findAll((HibCoreElement)project).stream().map(HibFieldSchemaElement::getLatestVersion).collect(Collectors.toList());
            List activeVersions = TestUtils.toList((Iterable)branch.findActiveSchemaVersions());
            ((AbstractListAssert)MeshAssertions.assertThat((List)activeVersions).as("List of schema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name", "version"})).containsAll(versions);
        }
    }

    @Test
    public void testBranchSchemaVersion() throws Exception {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibProject project = this.project();
            HibSchema schemaContainer = this.createSchemaDirect("bla");
            HibSchemaVersion firstVersion = (HibSchemaVersion)schemaContainer.getLatestVersion();
            EventQueueBatch batch = this.createBatch();
            schemaDao.assign((HibFieldSchemaElement)schemaContainer, project, this.user(), batch);
            this.updateSchema(schemaContainer, "newfield");
            HibSchemaVersion secondVersion = (HibSchemaVersion)schemaContainer.getLatestVersion();
            HibBranch initialBranch = this.reloadBranch(this.initialBranch());
            HibBranch newBranch = this.createBranch("New Branch");
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)initialBranch).as(initialBranch.getName(), new Object[0])).hasSchema(schemaContainer).hasSchemaVersion(firstVersion).hasNotSchemaVersion(secondVersion);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)newBranch).as(newBranch.getName(), new Object[0])).hasSchema(schemaContainer).hasNotSchemaVersion(firstVersion).hasSchemaVersion(secondVersion);
        }
    }

    @Test
    public void testReadMicroschemaVersions() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            List versions = tx.microschemaDao().findAll((HibCoreElement)project).stream().map(HibMicroschema::getLatestVersion).collect(Collectors.toList());
            ArrayList<HibMicroschemaVersion> found = new ArrayList<HibMicroschemaVersion>();
            for (HibMicroschemaVersion version : project.getInitialBranch().findAllMicroschemaVersions()) {
                found.add(version);
            }
            ((AbstractListAssert)MeshAssertions.assertThat(found).as("List of microschema versions", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name", "version"})).containsAll(versions);
        }
    }

    @Test
    public void testAssignMicroschema() throws Exception {
        try (Tx tx = this.tx();){
            HibMicroschema microschema = this.createMicroschemaDirect("bla");
            this.updateMicroschema(microschema, "newfield");
            HibMicroschemaVersion latestVersion = microschema.getLatestVersion();
            ((AbstractComparableAssert)MeshAssertions.assertThat((Comparable)latestVersion).as("latest version", new Object[0])).isNotNull();
            HibMicroschemaVersion previousVersion = latestVersion.getPreviousVersion();
            ((AbstractComparableAssert)MeshAssertions.assertThat((Comparable)previousVersion).as("Previous version", new Object[0])).isNotNull();
            HibProject project = this.project();
            HibBranch initialBranch = this.initialBranch();
            HibBranch newBranch = this.createBranch("New Branch");
            for (HibBranch branch : Arrays.asList(initialBranch, newBranch)) {
                branch = (HibBranch)((CommonTx)tx.unwrap()).load(branch.getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)project));
                ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasNotMicroschema(microschema).hasNotMicroschemaVersion(latestVersion).hasNotMicroschemaVersion(previousVersion);
            }
            tx.microschemaDao().assign((HibFieldSchemaElement)microschema, project, this.user(), this.createBatch());
            for (HibBranch branch : Arrays.asList(initialBranch, newBranch)) {
                branch = (HibBranch)((CommonTx)tx.unwrap()).load(branch.getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)project));
                ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasMicroschema(microschema).hasMicroschemaVersion(latestVersion).hasNotMicroschemaVersion(previousVersion);
            }
        }
    }

    @Test
    public void testUnassignMicroschema() throws Exception {
        try (Tx tx = this.tx();){
            MicroschemaDao microschemaDao = tx.microschemaDao();
            HibProject project = this.project();
            List microschemas = microschemaDao.findAll((HibCoreElement)project).list();
            HibMicroschema microschema = (HibMicroschema)microschemas.get(0);
            HibBranch initialBranch = this.initialBranch();
            HibBranch newBranch = this.createBranch("New Branch");
            microschemaDao.unassign((HibFieldSchemaElement)microschema, project, this.createBatch());
            for (HibBranch branch : Arrays.asList(initialBranch, newBranch)) {
                branch = (HibBranch)((CommonTx)tx.unwrap()).load(branch.getId(), ((CommonTx)tx.unwrap()).branchDao().getPersistenceClass((HibCoreElement)project));
                ((BranchAssert)MeshAssertions.assertThat((HibBranch)branch).as(branch.getName(), new Object[0])).hasNotMicroschema(microschema).hasNotMicroschemaVersion(microschema.getLatestVersion());
            }
        }
    }

    @Test
    public void testBranchMicroschemaVersion() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            HibMicroschema microschema = this.createMicroschemaDirect("bla");
            HibMicroschemaVersion firstVersion = microschema.getLatestVersion();
            tx.microschemaDao().assign((HibFieldSchemaElement)microschema, project, this.user(), this.createBatch());
            this.updateMicroschema(microschema, "newfield");
            HibMicroschemaVersion secondVersion = microschema.getLatestVersion();
            HibBranch initialBranch = this.reloadBranch(this.initialBranch());
            HibBranch newBranch = this.createBranch("New Branch");
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)initialBranch).as(initialBranch.getName(), new Object[0])).hasMicroschema(microschema).hasMicroschemaVersion(firstVersion).hasNotMicroschemaVersion(secondVersion);
            ((BranchAssert)MeshAssertions.assertThat((HibBranch)newBranch).as(newBranch.getName(), new Object[0])).hasMicroschema(microschema).hasNotMicroschemaVersion(firstVersion).hasMicroschemaVersion(secondVersion);
        }
    }

    protected HibSchema createSchemaDirect(String name) throws Exception {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName(name);
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schema.setDisplayField("name");
        SchemaDao schemaDao = Tx.get().schemaDao();
        return schemaDao.create((SchemaVersionModel)schema, this.user());
    }

    protected void updateSchema(HibSchema schemaContainer, String newName) throws Exception {
        SchemaVersionModel schema = ((HibSchemaVersion)schemaContainer.getLatestVersion()).getSchema();
        SchemaModelImpl updatedSchema = new SchemaModelImpl();
        updatedSchema.setName(schema.getName());
        updatedSchema.setDisplayField(schema.getDisplayField());
        updatedSchema.getFields().addAll(schema.getFields());
        updatedSchema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)newName));
        SchemaChangesListModel model = new SchemaChangesListModel();
        model.getChanges().addAll(new SchemaComparatorImpl().diff((SchemaModel)schema, (SchemaModel)updatedSchema));
        InternalActionContext ac = this.mockActionContext();
        EventQueueBatch batch = this.createBatch();
        Tx.get().schemaDao().applyChanges((HibFieldSchemaVersionElement)((HibSchemaVersion)schemaContainer.getLatestVersion()), ac, model, batch);
    }

    protected HibMicroschema createMicroschemaDirect(String name) throws Exception {
        MicroschemaModelImpl microschema = new MicroschemaModelImpl();
        microschema.setName(name);
        microschema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        return this.createMicroschema((MicroschemaVersionModel)microschema);
    }

    protected void updateMicroschema(HibMicroschema microschemaContainer, String newName) throws Exception {
        MicroschemaVersionModel microschemaModel = microschemaContainer.getLatestVersion().getSchema();
        MicroschemaModelImpl updatedMicroschemaModel = new MicroschemaModelImpl();
        updatedMicroschemaModel.setName(microschemaModel.getName());
        updatedMicroschemaModel.getFields().addAll(microschemaModel.getFields());
        updatedMicroschemaModel.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)newName));
        SchemaChangesListModel model = new SchemaChangesListModel();
        model.getChanges().addAll(new MicroschemaComparatorImpl().diff((MicroschemaModel)microschemaModel, (MicroschemaModel)updatedMicroschemaModel));
        InternalActionContext ac = this.mockActionContext();
        EventQueueBatch batch = this.createBatch();
        Tx.get().microschemaDao().applyChanges((HibFieldSchemaVersionElement)microschemaContainer.getLatestVersion(), ac, model, batch);
    }
}

