/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.container;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.container.AbstractFieldContainerDiffTest;
import com.gentics.mesh.core.container.FieldDiffTestcases;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.diff.FieldChangeTypes;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class FieldContainerFieldMapDiffTest
extends AbstractFieldContainerDiffTest
implements FieldDiffTestcases {
    @Override
    @Test
    public void testNoDiffByValue() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", (Field)FieldUtil.createStringField((String)"someValue"));
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertNoDiff(list);
        }
    }

    @Override
    public void testDiffByValue() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", (Field)FieldUtil.createStringField((String)"someValue2"));
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    public void testNoDiffByValuesNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString(null);
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", null);
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertNoDiff(list);
        }
    }

    @Override
    @Test
    public void testDiffByValueNonNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString(null);
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", (Field)FieldUtil.createStringField((String)"someValue2"));
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    public void testDiffByValueNonNull2() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue2");
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", null);
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    public void testDiffBySchemaFieldRemoved() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", null);
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    public void testDiffBySchemaFieldAdded() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", (Field)FieldUtil.createStringField((String)"someValue"));
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    @Ignore(value="Not applicable")
    public void testDiffBySchemaFieldTypeChanged() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            FieldMapImpl dummyMap = new FieldMapImpl();
            dummyMap.put("dummy", (Field)FieldUtil.createHtmlField((String)"someValue"));
            List list = Tx.get().contentDao().compareTo(containerA, (FieldMap)dummyMap);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }
}

