/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.container;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.container.AbstractFieldContainerDiffTest;
import com.gentics.mesh.core.container.FieldDiffTestcases;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.diff.FieldChangeTypes;
import com.gentics.mesh.core.data.diff.FieldContainerChange;
import com.gentics.mesh.core.data.node.field.list.HibStringFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibListableField;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
@NoConsistencyCheck
public class NodeFieldContainerDiffTest
extends AbstractFieldContainerDiffTest
implements FieldDiffTestcases {
    @Override
    @Test
    public void testNoDiffByValue() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerB.createString("dummy").setString("someValue");
            List list = contentDao.compareTo(containerA, containerB);
            this.assertNoDiff(list);
        }
    }

    @Override
    @Test
    public void testDiffByValue() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerB.createString("dummy").setString("someValue2");
            List list = contentDao.compareTo(containerA, containerB);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Test
    public void testNoDiffStringFieldList() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createListFieldSchema((String)"dummy").setListType("string")});
            HibStringFieldList listA = containerA.createStringList("dummy");
            listA.addItem((HibListableField)listA.createString("test123"));
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createListFieldSchema((String)"dummy").setListType("string")});
            HibStringFieldList listB = containerB.createStringList("dummy");
            listB.addItem((HibListableField)listB.createString("test123"));
            List list = contentDao.compareTo(containerA, containerB);
            this.assertNoDiff(list);
        }
    }

    @Test
    public void testDiffStringFieldList() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createListFieldSchema((String)"dummy").setListType("string")});
            HibStringFieldList listA = containerA.createStringList("dummy");
            listA.addItem((HibListableField)listA.createString("test123"));
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createListFieldSchema((String)"dummy").setListType("string")});
            HibStringFieldList listB = containerB.createStringList("dummy");
            listB.addItem((HibListableField)listB.createString("test1234"));
            List list = contentDao.compareTo(containerA, containerB);
            Assertions.assertThat((List)list).hasSize(1);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
            FieldContainerChange change = (FieldContainerChange)list.get(0);
            Assert.assertEquals((Object)"dummy", (Object)change.getFieldKey());
        }
    }

    @Test
    public void testDiffMicronodeField() throws IOException {
        MicronodeFieldSchema micronodeField = FieldUtil.createMicronodeFieldSchema((String)"micronodeField").setAllowedMicroSchemas(new String[]{"vcard"});
        HibMicroschemaVersion version = (HibMicroschemaVersion)this.tx(tx -> {
            HibMicroschema schemaContainer = this.createMicroschema(tx);
            HibMicroschemaVersion version1 = this.createMicroschemaVersion(tx, schemaContainer, v -> {
                schemaContainer.setLatestVersion(v);
                MicroschemaModelImpl microschema = new MicroschemaModelImpl();
                microschema.setName("vcard");
                microschema.getFields().add(FieldUtil.createStringFieldSchema((String)"firstName"));
                microschema.getFields().add(FieldUtil.createStringFieldSchema((String)"lastName"));
                v.setSchema((MicroschemaVersionModel)microschema);
            });
            tx.commit();
            this.prepareTypedMicroschema(schemaContainer, List.of(micronodeField));
            return version1;
        });
        try (Tx tx2 = this.tx();){
            ContentDao contentDao = tx2.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{micronodeField});
            HibMicronodeField micronodeA = containerA.createMicronode("micronodeField", version);
            micronodeA.getMicronode().createString("firstName").setString("firstnameValue");
            micronodeA.getMicronode().createString("lastName").setString("lastnameValue");
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createMicronodeFieldSchema((String)"micronodeField").setAllowedMicroSchemas(new String[]{"vcard"})});
            HibMicronodeField micronodeB = containerB.createMicronode("micronodeField", version);
            micronodeB.getMicronode().createString("firstName").setString("firstnameValue");
            micronodeB.getMicronode().createString("lastName").setString("lastnameValue-CHANGED");
            List list = contentDao.compareTo(containerA, containerB);
            Assertions.assertThat((List)list).hasSize(1);
            FieldContainerChange change = (FieldContainerChange)list.get(0);
            Assert.assertEquals((Object)FieldChangeTypes.UPDATED, (Object)change.getType());
            Assert.assertEquals((Object)"micronodeField", (Object)change.getFieldKey());
            Assert.assertEquals((Object)"micronodeField.lastName", (Object)change.getFieldCoordinates());
        }
    }

    @Override
    @Test
    public void testNoDiffByValuesNull() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString(null);
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerB.createString("dummy").setString(null);
            List list = contentDao.compareTo(containerA, containerB);
            this.assertNoDiff(list);
        }
    }

    @Override
    @Test
    public void testDiffByValueNonNull() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString(null);
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerB.createString("dummy").setString("someValue2");
            List list = contentDao.compareTo(containerA, containerB);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    public void testDiffByValueNonNull2() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue2");
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerB.createString("dummy").setString(null);
            List list = contentDao.compareTo(containerA, containerB);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }

    @Override
    @Test
    public void testDiffBySchemaFieldRemoved() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[0]);
            List list = contentDao.compareTo(containerA, containerB);
            this.assertChanges(list, FieldChangeTypes.REMOVED);
        }
    }

    @Override
    @Test
    public void testDiffBySchemaFieldAdded() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[0]);
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerB.createString("dummy").setString("someValue");
            List list = contentDao.compareTo(containerA, containerB);
            this.assertChanges(list, FieldChangeTypes.ADDED);
        }
    }

    @Override
    @Test
    public void testDiffBySchemaFieldTypeChanged() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer containerA = this.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
            containerA.createString("dummy").setString("someValue");
            HibNodeFieldContainer containerB = this.createContainer(new FieldSchema[]{FieldUtil.createHtmlFieldSchema((String)"dummy")});
            containerB.createHTML("dummy").setHtml("someValue");
            List list = contentDao.compareTo(containerA, containerB);
            this.assertChanges(list, FieldChangeTypes.UPDATED);
        }
    }
}

