/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data;

import com.gentics.mesh.util.VersionNumber;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class VersionNumberTest {
    @Test
    public void testInitialVersion() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber()).as("Initial Version", new Object[0])).hasToString("0.1");
    }

    @Test
    public void testSpecificVersion() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(47, 11)).as("Version", new Object[0])).hasToString("47.11");
    }

    @Test
    public void testNextDraft() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(0, 1).nextDraft()).as("Next Draft after 0.1", new Object[0])).hasToString("0.2");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(3, 0).nextDraft()).as("Next Draft after 3.0", new Object[0])).hasToString("3.1");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(47, 11).nextDraft()).as("Next Draft after 47.11", new Object[0])).hasToString("47.12");
    }

    @Test
    public void testNextPublished() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(0, 1).nextPublished()).as("Next Published after 0.1", new Object[0])).hasToString("1.0");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(3, 0).nextPublished()).as("Next Published after 3.0", new Object[0])).hasToString("4.0");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber(47, 11).nextPublished()).as("Next Published after 47.11", new Object[0])).hasToString("48.0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativMajor() {
        new VersionNumber(-3, 18);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativMinor() {
        new VersionNumber(18, -3);
    }

    @Test
    public void testFromString() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)new VersionNumber("47.11")).as("Version", new Object[0])).hasToString("47.11");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalPattern() {
        new VersionNumber("Bla");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnlyMajor() {
        new VersionNumber("47");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnlyMinor() {
        new VersionNumber(".11");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullVersion() {
        new VersionNumber(null);
    }

    @Test
    public void testEquals() {
        VersionNumber versionA = new VersionNumber("47.11");
        VersionNumber versionB = new VersionNumber("47.12");
        Assert.assertTrue((String)"VersionA should be equal to itself", (boolean)versionA.equals((Object)versionA));
        Assert.assertTrue((String)"VersionA should be equal to same value", (boolean)versionA.equals((Object)versionA.toString()));
        Assert.assertFalse((String)"VersionA should not be equal to versionB", (boolean)versionA.equals((Object)versionB));
        Assert.assertFalse((String)"VersionA should not be equal to versionB's value", (boolean)versionA.equals((Object)versionB.toString()));
        VersionNumber versionC = new VersionNumber("47.12");
        Assert.assertTrue((String)"VersionB should be equal to versionC since both have the same value.", (boolean)versionB.equals((Object)versionC));
    }

    @Test
    public void testCompareTo() {
        VersionNumber versionA = new VersionNumber("47.11");
        VersionNumber versionB = new VersionNumber("47.12");
        VersionNumber versionC = new VersionNumber("47.12");
        Assert.assertEquals((String)"VersionA should be smaller than versionB", (long)versionA.compareTo(versionB), (long)-1L);
        Assert.assertEquals((String)"VersionB should be greater than versionA", (long)versionB.compareTo(versionA), (long)1L);
        Assert.assertEquals((String)"VersionB should be equal to itself", (long)versionB.compareTo(versionB), (long)0L);
        Assert.assertEquals((String)"VersionB should be equal to versionC", (long)versionB.compareTo(versionC), (long)0L);
    }
}

