/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorBinaryTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<BinaryFieldSchema, C> {
    @Override
    public BinaryFieldSchema createField(String fieldName) {
        return FieldUtil.createBinaryFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        BinaryFieldSchema fieldA = FieldUtil.createBinaryFieldSchema((String)"test");
        fieldA.setAllowedMimeTypes(new String[]{"some", "values"});
        fieldA.setLabel("someLabel");
        fieldA.setRequired(true);
        BinaryFieldSchema fieldB = FieldUtil.createBinaryFieldSchema((String)"test");
        fieldB.setAllowedMimeTypes(new String[]{"some", "values"});
        fieldB.setLabel("someLabel");
        fieldB.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        BinaryFieldSchema fieldA = FieldUtil.createBinaryFieldSchema((String)"test");
        fieldA.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        BinaryFieldSchema fieldB = FieldUtil.createBinaryFieldSchema((String)"test");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setRequired(false);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)false);
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
        fieldB.setRequired(true);
        fieldB.setAllowedMimeTypes(new String[]{"one", "two"});
        changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("allow", (Object)new String[]{"one", "two"});
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
    }
}

