/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.BooleanFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorBooleanTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<BooleanFieldSchema, C> {
    @Override
    public BooleanFieldSchema createField(String fieldName) {
        return FieldUtil.createBooleanFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        BooleanFieldSchema fieldA = this.createField("test");
        fieldA.setRequired(true);
        fieldA.setLabel("label1");
        containerA.addField((FieldSchema)fieldA);
        BooleanFieldSchema fieldB = this.createField("test");
        fieldB.setRequired(true);
        fieldB.setLabel("label1");
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        BooleanFieldSchema fieldA = this.createField("test");
        containerA.addField((FieldSchema)fieldA);
        BooleanFieldSchema fieldB = this.createField("test");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setRequired(true);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)true);
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
    }
}

