/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.HtmlFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorHtmlTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<HtmlFieldSchema, C> {
    @Override
    public HtmlFieldSchema createField(String fieldName) {
        return FieldUtil.createHtmlFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        HtmlFieldSchema fieldA = FieldUtil.createHtmlFieldSchema((String)"test");
        fieldA.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        HtmlFieldSchema fieldB = FieldUtil.createHtmlFieldSchema((String)"test");
        fieldB.setRequired(true);
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        HtmlFieldSchema fieldA = FieldUtil.createHtmlFieldSchema((String)"test");
        fieldA.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        HtmlFieldSchema fieldB = FieldUtil.createHtmlFieldSchema((String)"test");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setRequired(false);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)false);
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
    }
}

