/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorListSchemaTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<ListFieldSchema, C> {
    @Override
    public ListFieldSchema createField(String fieldName) {
        ListFieldSchema field = FieldUtil.createListFieldSchema((String)"test");
        field.setListType("html");
        return field;
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        containerA.setName("test");
        Object containerB = this.createContainer();
        containerB.setName("test");
        ListFieldSchema fieldA = FieldUtil.createListFieldSchema((String)"test");
        fieldA.setListType("html");
        fieldA.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        ListFieldSchema fieldB = FieldUtil.createListFieldSchema((String)"test");
        fieldB.setListType("html");
        fieldB.setRequired(true);
        containerB.addField((FieldSchema)fieldB);
        List list = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)list).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        containerA.setName("test");
        Object containerB = this.createContainer();
        containerB.setName("test");
        ListFieldSchema fieldA = FieldUtil.createListFieldSchema((String)"test");
        fieldA.setRequired(true);
        fieldA.setListType("html");
        containerA.addField((FieldSchema)fieldA);
        ListFieldSchema fieldB = FieldUtil.createListFieldSchema((String)"test");
        fieldB.setListType("html");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setRequired(false);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)false);
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
        fieldB.setRequired(true);
        fieldB.setListType("boolean");
        changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("listType", (Object)"boolean");
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
        fieldB.setAllowedSchemas(new String[]{"test"});
        changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("allow", (Object)new String[]{"test"});
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(3);
    }
}

