/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorMicronodeTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<MicronodeFieldSchema, C> {
    @Override
    public MicronodeFieldSchema createField(String fieldName) {
        return FieldUtil.createMicronodeFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        MicronodeFieldSchema fieldA = FieldUtil.createMicronodeFieldSchema((String)"test");
        fieldA.setRequired(true);
        fieldA.setLabel("label1");
        fieldA.setAllowedMicroSchemas(new String[]{"one", "two"});
        containerA.addField((FieldSchema)fieldA);
        MicronodeFieldSchema fieldB = FieldUtil.createMicronodeFieldSchema((String)"test");
        fieldB.setRequired(true);
        fieldB.setLabel("label1");
        fieldB.setAllowedMicroSchemas(new String[]{"one", "two"});
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        MicronodeFieldSchema fieldA = FieldUtil.createMicronodeFieldSchema((String)"test");
        fieldA.setRequired(true);
        fieldA.setLabel("label1");
        fieldA.setAllowedMicroSchemas(new String[]{"one", "two"});
        containerA.addField((FieldSchema)fieldA);
        MicronodeFieldSchema fieldB = FieldUtil.createMicronodeFieldSchema((String)"test");
        fieldB.setRequired(true);
        fieldB.setLabel("label2");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setAllowedMicroSchemas(new String[]{"one", "two", "three"});
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasNoProperty("required").hasProperty("allow", (Object)new String[]{"one", "two", "three"}).hasProperty("label", (Object)"label2");
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(3);
        fieldB.setAllowedMicroSchemas(new String[]{"one", "two"});
        fieldB.setRequired(false);
        changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)false).hasNoProperty("allow");
    }
}

