/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.NodeFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorNodeTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<NodeFieldSchema, C> {
    @Override
    public NodeFieldSchema createField(String fieldName) {
        return FieldUtil.createNodeFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        NodeFieldSchema fieldA = this.createField("test");
        fieldA.setRequired(true);
        fieldA.setAllowedSchemas(new String[]{"one", "two"});
        fieldA.setLabel("label1");
        containerA.addField((FieldSchema)fieldA);
        NodeFieldSchema fieldB = this.createField("test");
        fieldB.setRequired(true);
        fieldB.setAllowedSchemas(new String[]{"one", "two"});
        fieldB.setLabel("label1");
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object schemaA = this.createContainer();
        Object schemaB = this.createContainer();
        NodeFieldSchema fieldA = this.createField("test");
        fieldA.setRequired(true);
        fieldA.setAllowedSchemas(new String[]{"one", "two"});
        fieldA.setLabel("label1");
        schemaA.addField((FieldSchema)fieldA);
        NodeFieldSchema fieldB = this.createField("test");
        fieldB.setRequired(true);
        fieldB.setAllowedSchemas(new String[]{"one", "two", "three"});
        fieldB.setLabel("label1");
        schemaB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(schemaA, schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("allow", (Object)new String[]{"one", "two", "three"});
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
        fieldA.setAllowedSchemas(new String[]{"one", "two", "three"});
        fieldB.setRequired(false);
        changes = this.getComparator().diff(schemaA, schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasNoProperty("allow").hasProperty("required", (Object)false);
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
    }
}

