/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.NumberFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorNumberTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<NumberFieldSchema, C> {
    @Override
    public NumberFieldSchema createField(String fieldName) {
        return FieldUtil.createNumberFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        NumberFieldSchema fieldA = this.createField("test");
        fieldA.setLabel("label1");
        fieldA.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        Object containerB = this.createContainer();
        NumberFieldSchema fieldB = this.createField("test");
        fieldB.setRequired(true);
        fieldB.setLabel("label1");
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        NumberFieldSchema fieldA = this.createField("test");
        fieldA.setLabel("label1");
        fieldA.setRequired(true);
        containerA.addField((FieldSchema)fieldA);
        Object containerB = this.createContainer();
        NumberFieldSchema fieldB = this.createField("test");
        fieldB.setRequired(true);
        fieldB.setLabel("label2");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setRequired(false);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)false).hasProperty("label", (Object)"label2");
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(3);
        fieldB.setRequired(true);
    }
}

