/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.fieldhandler.AbstractSchemaComparatorTest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.NumberFieldSchema;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.util.IndexOptionHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public abstract class AbstractComparatorStringTest<C extends FieldSchemaContainer>
extends AbstractSchemaComparatorTest<StringFieldSchema, C> {
    @Override
    public StringFieldSchema createField(String fieldName) {
        return FieldUtil.createStringFieldSchema((String)fieldName);
    }

    @Override
    @Test
    public void testSameField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        containerA.addField((FieldSchema)this.createField("test"));
        containerB.addField((FieldSchema)this.createField("test"));
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Override
    @Test
    public void testChangeFieldLabel() throws IOException {
        Object containerA = this.createContainer();
        containerA.setName("test");
        NumberFieldSchema fieldA = FieldUtil.createNumberFieldSchema((String)"test");
        fieldA.setLabel("OriginalLabel");
        containerA.addField((FieldSchema)fieldA);
        String newLabel = "UpdatedLabel";
        Object containerB = this.createContainer();
        containerB.setName("test");
        StringFieldSchema fieldB = this.createField("test");
        fieldB.setAllowedValues(new String[]{"testValueAllowed"});
        fieldB.setLabel(newLabel);
        containerB.addField((FieldSchema)fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.CHANGEFIELDTYPE).forField("test").hasProperty("label", (Object)newLabel).hasProperty("allow", (Object)new String[]{"testValueAllowed"}).hasProperty("type", (Object)"string");
    }

    @Override
    @Test
    public void testUpdateField() throws IOException {
        Object containerA = this.createContainer();
        Object containerB = this.createContainer();
        StringFieldSchema fieldA = this.createField("test");
        containerA.addField((FieldSchema)fieldA);
        StringFieldSchema fieldB = this.createField("test");
        containerB.addField((FieldSchema)fieldB);
        fieldB.setRequired(true);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)true);
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
        fieldB.setElasticsearch(IndexOptionHelper.getRawFieldOption());
        changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("required", (Object)true).hasProperty("elasticsearch", (Object)IndexOptionHelper.getRawFieldOption());
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(3);
        fieldA.setRequired(true);
        fieldA.setElasticsearch(IndexOptionHelper.getRawFieldOption());
        fieldA.setAllowedValues(new String[]{"blib"});
        fieldB.setAllowedValues(new String[]{"changed"});
        changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasNoProperty("elasticsearch").hasNoProperty("required").hasProperty("allow", (Object)new String[]{"changed"});
        MeshAssertions.assertThat((Map)((SchemaChangeModel)changes.get(0)).getProperties()).hasSize(2);
    }
}

