/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.handler.AbstractFieldSchemaContainerComparator;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.HtmlFieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.List;
import org.junit.Test;

public abstract class AbstractSchemaComparatorTest<T extends FieldSchema, C extends FieldSchemaContainer>
extends AbstractMeshTest {
    public abstract AbstractFieldSchemaContainerComparator<C> getComparator();

    public abstract C createContainer();

    public abstract T createField(String var1);

    public abstract void testSameField() throws IOException;

    @Test
    public void testAddField() {
        C containerA = this.createContainer();
        containerA.setName("test");
        containerA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"first"));
        C containerB = this.createContainer();
        containerB.setName("test");
        containerB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"first"));
        T field = this.createField("test");
        JsonObject indexSettings = new JsonObject().put("settings", (Object)"test");
        field.setElasticsearch(indexSettings);
        containerB.addField(field);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(2);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.ADDFIELD).forField("test").hasProperty("type", (Object)field.getType()).hasProperty("after", (Object)"first").hasProperty("elasticsearch", (Object)indexSettings);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(1))).isUpdateOperation(containerA);
    }

    @Test
    public void testAddFieldToSchema() throws IOException {
        C containerA = this.createContainer();
        containerA.setName("test");
        C containerB = this.createContainer();
        containerB.setName("test");
        T field = this.createField("test");
        containerB.addField(field);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(2);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.ADDFIELD).forField("test").hasProperty("type", (Object)field.getType());
        if (containerA.getFields().size() > 0) {
            String lastField = ((FieldSchema)containerA.getFields().get(containerA.getFields().size() - 1)).getName();
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).hasProperty("after", (Object)lastField);
        } else {
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).hasNoProperty("order");
        }
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(1))).isUpdateOperation(containerA);
    }

    @Test
    public void testRemoveField() throws IOException {
        C containerA = this.createContainer();
        containerA.addField(this.createField("test"));
        C containerB = this.createContainer();
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.REMOVEFIELD).forField("test");
    }

    public abstract void testUpdateField() throws IOException;

    @Test
    public void testChangeFieldLabel() throws IOException {
        C containerA = this.createContainer();
        containerA.setName("test");
        T fieldA = this.createField("test");
        fieldA.setLabel("OriginalLabel");
        containerA.addField(fieldA);
        String newLabel = "UpdatedLabel";
        C containerB = this.createContainer();
        containerB.setName("test");
        T fieldB = this.createField("test");
        fieldB.setLabel(newLabel);
        containerB.addField(fieldB);
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATEFIELD).forField("test").hasProperty("label", (Object)newLabel);
    }

    @Test
    public void testChangeFieldType() throws IOException {
        HtmlFieldSchema fieldB;
        C containerA = this.createContainer();
        containerA.setName("test");
        T fieldA = this.createField("test");
        containerA.addField(fieldA);
        String newType = "html";
        C containerB = this.createContainer();
        containerB.setName("test");
        if (fieldA instanceof ListFieldSchema) {
            fieldB = FieldUtil.createHtmlFieldSchema((String)"test");
            containerB.addField((FieldSchema)fieldB);
        } else {
            fieldB = FieldUtil.createListFieldSchema((String)"test");
            fieldB.setListType("html");
            containerB.addField((FieldSchema)fieldB);
            newType = "list";
        }
        List changes = this.getComparator().diff(containerA, containerB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.CHANGEFIELDTYPE).forField("test").hasProperty("type", (Object)newType);
        if ("list".equals(newType)) {
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).hasProperty("listType", (Object)"html");
        }
    }
}

