/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler.microschema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.handler.MicroschemaComparatorImpl;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import java.util.List;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class SchemaComparatorMicroschemaTest
extends AbstractMeshTest {
    @Test
    public void testEmptyMicroschema() throws IOException {
        MicroschemaVersionModel schemaA = FieldUtil.createMinimalValidMicroschema();
        MicroschemaVersionModel schemaB = FieldUtil.createMinimalValidMicroschema();
        List changes = new MicroschemaComparatorImpl().diff((MicroschemaModel)schemaA, (MicroschemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testSchemaFieldReorder() throws IOException {
        MicroschemaVersionModel schemaA = FieldUtil.createMinimalValidMicroschema();
        schemaA.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
        schemaA.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
        MicroschemaVersionModel schemaB = FieldUtil.createMinimalValidMicroschema();
        schemaB.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
        schemaB.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
        List changes = new MicroschemaComparatorImpl().diff((MicroschemaModel)schemaA, (MicroschemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).isUpdateOperation((Object)schemaA).hasProperty("order", (Object)new String[]{"second", "first"});
    }
}

