/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.fieldhandler.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.handler.SchemaComparatorImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class SchemaComparatorSchemaTest
extends AbstractMeshTest {
    private SchemaComparatorImpl comparator = new SchemaComparatorImpl();

    @Test
    public void testEmptySchema() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testChangeFieldType() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"content"));
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.addField((FieldSchema)FieldUtil.createNumberFieldSchema((String)"content"));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.CHANGEFIELDTYPE).hasProperty("field", (Object)"content").hasProperty("type", (Object)"number");
    }

    @Test
    public void testSchemaFieldReorder() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
        schemaA.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
        schemaB.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("order", (Object)new String[]{"second", "first"});
    }

    @Test
    public void testSegmentFieldAdded() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.setDisplayField("displayFieldName");
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.setDisplayField("displayFieldName");
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaB.setSegmentField(((FieldSchema)schemaB.getFields().get(0)).getName());
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        Assert.assertEquals((Object)SchemaChangeOperation.UPDATESCHEMA, (Object)((SchemaChangeModel)changes.get(0)).getOperation());
    }

    @Test
    public void testSegmentFieldRemoved() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.setDisplayField("displayFieldName");
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaA.setSegmentField(((FieldSchema)schemaA.getFields().get(0)).getName());
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.setDisplayField("displayFieldName");
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        Assert.assertEquals((Object)SchemaChangeOperation.UPDATESCHEMA, (Object)((SchemaChangeModel)changes.get(0)).getOperation());
    }

    @Test
    public void testSchemaFieldNoReorder() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
        schemaA.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
        schemaB.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testSegmentFieldSame() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.setDisplayField("displayFieldName");
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaA.setSegmentField(((FieldSchema)schemaA.getFields().get(0)).getName());
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.setDisplayField("displayFieldName");
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaB.setSegmentField(schemaA.getSegmentField());
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testSegmentFieldUpdated() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"someExtraField"));
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaA.setSegmentField("someExtraField");
        schemaA.validate();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"someExtraField"));
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaB.setSegmentField("displayFieldName");
        schemaB.validate();
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("segmentFieldname", (Object)"displayFieldName");
    }

    @Test
    public void testDisplayFieldUpdated() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"someExtraField"));
        schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaA.setDisplayField("displayFieldName");
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"someExtraField"));
        schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"displayFieldName"));
        schemaB.setDisplayField("someExtraField");
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("displayFieldname", (Object)"someExtraField");
    }

    @Test
    public void testDisplayFieldSame() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testContainerFlagUpdated() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setContainer(Boolean.valueOf(true));
        schemaB.setContainer(Boolean.valueOf(false));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("container", (Object)false);
    }

    @Test
    public void testContainerFlagSame() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setContainer(Boolean.valueOf(true));
        schemaB.setContainer(Boolean.valueOf(true));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
        schemaA.setContainer(Boolean.valueOf(false));
        schemaB.setContainer(Boolean.valueOf(false));
        changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testAutoPurgeFlagUpdated() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setAutoPurge(Boolean.valueOf(true));
        schemaB.setAutoPurge(Boolean.valueOf(false));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("autoPurge", (Object)false);
    }

    @Test
    public void testAutoPurgeFlagSame() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setAutoPurge(Boolean.valueOf(true));
        schemaB.setAutoPurge(Boolean.valueOf(true));
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
        schemaA.setAutoPurge(Boolean.valueOf(false));
        schemaB.setAutoPurge(Boolean.valueOf(false));
        changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testAutoPurgeFlagNull() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setAutoPurge(Boolean.valueOf(true));
        schemaB.setAutoPurge(null);
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("autoPurge", null);
    }

    @Test
    public void testSameDescription() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setDescription("test123");
        schemaB.setDescription("test123");
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testDescriptionUpdated() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setDescription("test123");
        schemaB.setDescription("test123-changed");
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("description", (Object)"test123-changed");
    }

    @Test
    public void testDescriptionUpdatedToNull() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setDescription("test123");
        schemaB.setDescription(null);
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("description", null);
    }

    @Test
    public void testSameName() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setName("test123");
        schemaB.setName("test123");
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).isEmpty();
    }

    @Test
    public void testNameUpdated() throws IOException {
        SchemaVersionModel schemaA = FieldUtil.createMinimalValidSchema();
        SchemaVersionModel schemaB = FieldUtil.createMinimalValidSchema();
        schemaA.setName("test123");
        schemaB.setName("test123_changed");
        List changes = this.comparator.diff((SchemaModel)schemaA, (SchemaModel)schemaB);
        MeshAssertions.assertThat((List)changes).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("name", (Object)"test123_changed");
    }
}

