/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.data.service;

import com.gentics.mesh.context.AbstractActionContext;
import com.gentics.mesh.core.data.i18n.I18NUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Locale;
import java.util.MissingResourceException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class I18NTest
extends AbstractMeshTest {
    @Test
    public void testGerman() {
        Locale locale = new Locale("de", "DE");
        Assert.assertEquals((Object)"Fehler", (Object)I18NUtil.get((Locale)locale, (String)"error"));
    }

    @Test
    public void testEnglish() {
        Locale locale = new Locale("en", "US");
        Assert.assertEquals((Object)"Error", (Object)I18NUtil.get((Locale)locale, (String)"error"));
    }

    @Test
    public void testFallback() {
        Locale locale = new Locale("jp");
        Assert.assertEquals((Object)"Error", (Object)I18NUtil.get((Locale)locale, (String)"error"));
    }

    @Test(expected=MissingResourceException.class)
    public void testWrongI18NKey() {
        Locale locale = new Locale("jp");
        I18NUtil.get((Locale)locale, (String)"fadsfgasdgasdg");
    }

    @Test
    public void testWrongI18NKey2() {
        Locale locale = new Locale("jp");
        String bogusKey = "fadsfgasdgasdg";
        Assert.assertEquals((Object)bogusKey, (Object)I18NUtil.get((Locale)locale, (String)bogusKey, (String[])new String[]{"test"}));
    }

    @Test
    public void testFormattedMessage() {
        Locale locale = new Locale("de", "DE");
        Assert.assertEquals((Object)"Gruppe konnte nicht gefunden werden: \"testgroup\"", (Object)I18NUtil.get((Locale)locale, (String)"group_not_found", (String[])new String[]{"testgroup"}));
    }

    @Test
    public void testLocaleFromHeader() {
        Locale locale = AbstractActionContext.getLocale((String)"da, en-gb;q=0.8, en;q=0.7, de;q=0.81");
        Assert.assertEquals((Object)"de", (Object)locale.getLanguage());
        locale = AbstractActionContext.getLocale((String)"da, en-gb;q=0.9, en;q=0.7, de;q=0.81");
        Assert.assertEquals((Object)"en", (Object)locale.getLanguage());
        locale = AbstractActionContext.getLocale((String)"de, en-gb;q=0.9, en;q=0.7, de;q=0.81");
        Assert.assertEquals((Object)"de", (Object)locale.getLanguage());
    }
}

