/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.eventbus;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRestClientUtil;
import com.gentics.mesh.rest.client.MeshWebsocket;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.RxUtil;
import io.reactivex.Completable;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class EventbusEndpointTest
extends AbstractMeshTest {
    private MeshWebsocket ws;

    @Before
    public void setupEventbus() throws Exception {
        this.ws = this.client().eventbus();
        this.ws.connections().blockingFirst();
    }

    @After
    public void closeEventBus() {
        if (this.ws != null) {
            this.ws.close();
        }
    }

    @Test(timeout=4000L)
    public void testExternalEventbusMessage(TestContext context) throws Exception {
        Async async = context.async();
        MeshEvent allowedAddress = MeshEvent.USER_CREATED;
        this.ws.registerEvents(new MeshEvent[]{allowedAddress});
        this.ws.events().firstOrError().subscribe(event -> {
            MeshAssertions.assertThat((String)event.getBodyAsJson().get("test").textValue()).isEqualTo((Object)"someValue");
            async.complete();
        });
        Thread.sleep(1000L);
        this.vertx().eventBus().publish(allowedAddress.address, (Object)new JsonObject().put("test", (Object)"someValue"));
    }

    @Test(timeout=4000L)
    public void testNodeDeleteEvent(TestContext context) throws Exception {
        Async async = context.async();
        this.ws.registerEvents(new MeshEvent[]{MeshEvent.NODE_DELETED});
        this.ws.events().firstOrError().subscribe(event -> {
            NodeMeshEventModel body = (NodeMeshEventModel)JsonUtil.readValue((String)event.getBodyAsJson().toString(), NodeMeshEventModel.class);
            context.assertNotNull((Object)body.getUuid());
            context.assertEquals((Object)"content", (Object)body.getSchema().getName());
            async.complete();
        });
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), new ParameterProvider[0]));
    }

    @Test(timeout=4000L)
    public void testNodeDeleteLanguageEvent(TestContext context) throws Exception {
        Async async = context.async();
        this.ws.registerEvents(new MeshEvent[]{MeshEvent.NODE_CONTENT_DELETED});
        this.ws.errors().subscribe(arg_0 -> ((TestContext)context).fail(arg_0));
        this.ws.events().firstOrError().subscribe(event -> {
            NodeMeshEventModel body = (NodeMeshEventModel)JsonUtil.readValue((String)event.getBodyAsJson().toString(), NodeMeshEventModel.class);
            context.assertNotNull((Object)body.getUuid());
            context.assertEquals((Object)"content", (Object)body.getSchema().getName());
            context.assertEquals((Object)"en", (Object)body.getLanguageTag());
            async.complete();
        });
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), "en", new ParameterProvider[0]));
    }

    @Test(timeout=4000L)
    public void testNodeUpdateEvent(TestContext context) {
        Async async = context.async();
        this.ws.registerEvents(new MeshEvent[]{MeshEvent.NODE_UPDATED});
        this.ws.events().firstOrError().subscribe(event -> {
            NodeMeshEventModel body = (NodeMeshEventModel)JsonUtil.readValue((String)event.getBodyAsJson().toString(), NodeMeshEventModel.class);
            Assert.assertNotNull((Object)body.getUuid());
            Assert.assertEquals((Object)"content", (Object)body.getSchema().getName());
            async.complete();
        });
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]));
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub"));
        request.setVersion(response.getVersion());
        request.setLanguage("en");
        ClientHelper.call(() -> this.client().updateNode("dummy", this.contentUuid(), request, new ParameterProvider[0]));
        NodeResponse response2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]));
        Assert.assertNotEquals((Object)response.getVersion(), (Object)response2.getVersion());
    }

    @Test
    public void testCustomEventHandling(TestContext context) {
        Async asyncRec = context.async();
        this.ws.registerEvents(new String[]{"custom.myEvent"});
        this.ws.events().firstOrError().subscribe(event -> {
            String body = event.getBodyAsString();
            Assert.assertEquals((Object)"someText", (Object)body);
            asyncRec.complete();
        });
        this.ws.publishEvent("custom.myEvent", (Object)"someText");
    }

    @Test
    public void testOneOfHelper(TestContext context) {
        Async async = context.async(2);
        this.ws.registerEvents(new MeshEvent[]{MeshEvent.NODE_UPDATED});
        this.ws.events().firstOrError().subscribe(event -> {
            NodeMeshEventModel body = (NodeMeshEventModel)JsonUtil.readValue((String)event.getBodyAsJson().toString(), NodeMeshEventModel.class);
            Assert.assertNotNull((Object)body.getUuid());
            Assert.assertEquals((Object)"content", (Object)body.getSchema().getName());
            async.countDown();
        });
        this.ws.events().filter(MeshRestClientUtil.isOneOf((MeshEvent[])new MeshEvent[]{MeshEvent.NODE_UPDATED})).subscribe(ignore -> async.countDown());
        this.ws.events().filter(MeshRestClientUtil.isOneOf((MeshEvent[])new MeshEvent[]{MeshEvent.NODE_CREATED})).subscribe(ignore -> context.fail("No node should have been created"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]));
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub"));
        request.setVersion(response.getVersion());
        request.setLanguage("en");
        ClientHelper.call(() -> this.client().updateNode("dummy", this.contentUuid(), request, new ParameterProvider[0]));
        NodeResponse response2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]));
        Assert.assertNotEquals((Object)response.getVersion(), (Object)response2.getVersion());
    }

    @Test
    public void testHeartbeat() throws InterruptedException {
        this.ws.errors().subscribe(ignore -> Assert.fail());
        Thread.sleep(10000L);
    }

    private Completable verifyStoppedRestVerticle() {
        return this.client().me(new ParameterProvider[0]).toCompletable().compose(RxUtil::flip);
    }
}

